/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.util;

import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.EntityTrackUpgradeHandler;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import net.minecraft.block.BlockState;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class ClientUtils {
    public static void emitParticles(World world, BlockPos pos, IParticleData particle) {
        float xOff = world.field_73012_v.nextFloat() * 0.6f + 0.2f;
        float zOff = world.field_73012_v.nextFloat() * 0.6f + 0.2f;
        ClientUtils.getClientWorld().func_195594_a(particle, (double)((float)pos.func_177958_n() + xOff), (double)pos.func_177956_o() + 1.2, (double)((float)pos.func_177952_p() + zOff), 0.0, 0.0, 0.0);
    }

    @Nonnull
    public static ItemStack getWornArmor(EquipmentSlotType slot) {
        return Minecraft.func_71410_x().field_71439_g.func_184582_a(slot);
    }

    public static void addDroneToHudHandler(EntityDrone drone, BlockPos pos) {
        HUDHandler.instance().getSpecificRenderer(EntityTrackUpgradeHandler.class).getTargetsStream().filter(target -> target.entity == drone).forEach(target -> target.getDroneAIRenderer().addBlackListEntry(drone.field_70170_p, pos));
    }

    public static boolean isKeyDown(int keyCode) {
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)keyCode);
    }

    public static void openContainerGui(ContainerType<? extends Container> type, ITextComponent displayString) {
        ScreenManager.func_216909_a(type, (Minecraft)Minecraft.func_71410_x(), (int)-1, (ITextComponent)displayString);
    }

    public static World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    public static PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static boolean hasShiftDown() {
        return Screen.hasShiftDown();
    }

    public static TileEntity getClientTE(BlockPos pos) {
        return Minecraft.func_71410_x().field_71441_e.func_175625_s(pos);
    }

    public static boolean intersects(Rectangle2d rect, double x, double y, double w, double h) {
        if (rect.func_199316_c() <= 0 || rect.func_199317_d() <= 0 || w <= 0.0 || h <= 0.0) {
            return false;
        }
        double x0 = rect.func_199318_a();
        double y0 = rect.func_199319_b();
        return x + w > x0 && y + h > y0 && x < x0 + (double)rect.func_199316_c() && y < y0 + (double)rect.func_199317_d();
    }

    public static void suppressItemEquipAnimation() {
        FirstPersonRenderer renderer = Minecraft.func_71410_x().func_175597_ag();
        renderer.field_187469_f = 1.0f;
        renderer.field_187470_g = 1.0f;
    }

    public static boolean isScreenHiRes() {
        MainWindow mw = Minecraft.func_71410_x().func_228018_at_();
        return mw.func_198107_o() > 700 && mw.func_198087_p() > 512;
    }

    public static Iterable<? extends Entity> getAllEntities(World world) {
        return ((ClientWorld)world).func_217416_b();
    }

    public static float getBrightnessAtWorldHeight() {
        PlayerEntity player = ClientUtils.getClientPlayer();
        BlockPos.Mutable pos = new BlockPos.Mutable(player.func_226277_ct_(), (double)player.field_70170_p.getMaxHeight(), player.func_226281_cx_());
        if (player.field_70170_p.func_175667_e((BlockPos)pos)) {
            return player.field_70170_p.func_201675_m().func_227174_a_(player.field_70170_p.func_201696_r((BlockPos)pos));
        }
        return 0.0f;
    }

    public static int getStringWidth(String line) {
        return Minecraft.func_71410_x().func_175598_ae().func_78716_a().func_78256_a(line);
    }

    public static boolean isGuiOpen() {
        return Minecraft.func_71410_x().field_71462_r != null;
    }

    public static float[] getTextureUV(BlockState state, Direction face) {
        if (state == null) {
            return null;
        }
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        List quads = model.getQuads(state, face, Minecraft.func_71410_x().field_71441_e.field_73012_v, (IModelData)EmptyModelData.INSTANCE);
        if (!quads.isEmpty()) {
            TextureAtlasSprite sprite = ((BakedQuad)quads.get(0)).func_187508_a();
            return new float[]{sprite.func_94209_e(), sprite.func_94206_g(), sprite.func_94212_f(), sprite.func_94210_h()};
        }
        return null;
    }
}

