/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.desht.pneumaticcraft.api.client.assembly_machine.IAssemblyRenderOverriding;
import me.desht.pneumaticcraft.client.GuiRegistry;
import me.desht.pneumaticcraft.client.render.tileentity.AbstractTileModelRenderer;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyPlatform;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.tuple.Pair;

public class RenderAssemblyPlatform
extends AbstractTileModelRenderer<TileEntityAssemblyPlatform> {
    private static final float ITEM_SCALE = 0.5f;
    private final ModelRenderer claw1 = new ModelRenderer(64, 64, 0, 32);
    private final ModelRenderer claw2;

    public RenderAssemblyPlatform(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        this.claw1.func_228300_a_(0.0f, 0.0f, 0.0f, 2.0f, 1.0f, 1.0f);
        this.claw1.func_78793_a(-1.0f, 17.0f, 0.0f);
        this.claw1.field_78809_i = true;
        this.claw2 = new ModelRenderer(64, 64, 0, 32);
        this.claw2.func_228300_a_(0.0f, 0.0f, 0.0f, 2.0f, 1.0f, 1.0f);
        this.claw2.func_78793_a(-1.0f, 17.0f, -1.0f);
        this.claw2.field_78809_i = true;
    }

    @Override
    public void renderModel(TileEntityAssemblyPlatform te, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        IAssemblyRenderOverriding renderOverride;
        ItemStack heldStack = te.getPrimaryInventory().getStackInSlot(0);
        Pair<IAssemblyRenderOverriding, Float> clawTranslation = this.getClawTranslation(MathHelper.func_219799_g((float)partialTicks, (float)te.oldClawProgress, (float)te.clawProgress), heldStack);
        IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228638_b_((ResourceLocation)Textures.MODEL_ASSEMBLY_PLATFORM));
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, 0.0, (double)((Float)clawTranslation.getRight()).floatValue());
        this.claw1.func_228308_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.func_227861_a_(0.0, 0.0, (double)(-2.0f * ((Float)clawTranslation.getRight()).floatValue()));
        this.claw2.func_228308_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.func_227865_b_();
        if (!heldStack.func_190926_b() && ((renderOverride = (IAssemblyRenderOverriding)clawTranslation.getLeft()) == null || renderOverride.applyRenderChangePlatform(matrixStackIn, heldStack))) {
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
            double yOffset = heldStack.func_77973_b() instanceof BlockItem ? -1.03125 : -1.09375;
            matrixStackIn.func_227861_a_(0.0, yOffset + 0.05, 0.0);
            matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
            ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
            IBakedModel ibakedmodel = itemRenderer.func_184393_a(heldStack, te.func_145831_w(), null);
            itemRenderer.func_229111_a_(heldStack, ItemCameraTransforms.TransformType.FIXED, true, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, ibakedmodel);
        }
    }

    private Pair<IAssemblyRenderOverriding, Float> getClawTranslation(float clawProgress, ItemStack heldStack) {
        IAssemblyRenderOverriding renderOverride = null;
        float clawTrans = !heldStack.func_190926_b() ? ((renderOverride = GuiRegistry.renderOverrides.get(heldStack.func_77973_b().getRegistryName())) != null ? renderOverride.getPlatformClawShift(heldStack) : (heldStack.func_77973_b() instanceof BlockItem ? 0.09375f - clawProgress * 0.1f / 16.0f : 0.09375f - clawProgress * 1.4f / 16.0f)) : 0.09375f - clawProgress * 1.5f / 16.0f;
        return Pair.of((Object)renderOverride, (Object)Float.valueOf(clawTrans));
    }
}

