/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.inventory.ContainerInventorySearcher;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class GuiInventorySearcher
extends ContainerScreen<ContainerInventorySearcher> {
    private final ItemStackHandler inventory = new ItemStackHandler(1);
    private final Screen parentScreen;
    private Predicate<ItemStack> stackPredicate = itemStack -> true;
    private WidgetLabel label;

    public GuiInventorySearcher(ContainerInventorySearcher container, PlayerInventory inv, ITextComponent title) {
        super((Container)container, inv, title);
        inv.field_70458_d.field_71070_bA = container;
        this.passEvents = true;
        this.field_147000_g = 176;
        this.parentScreen = Minecraft.func_71410_x().field_71462_r;
        container.init((IItemHandler)this.inventory);
    }

    protected void init() {
        super.init();
        this.label = new WidgetLabel(this.field_147003_i + 105, this.field_147009_r + 28, "", -12566400);
        this.addButton(this.label);
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    public void onClose() {
        this.minecraft.field_195559_v.func_197967_a(false);
        if (this.parentScreen != null) {
            this.minecraft.func_147108_a(this.parentScreen);
            if (this.parentScreen instanceof ContainerScreen) {
                this.minecraft.field_71439_g.field_71070_bA = ((ContainerScreen)this.parentScreen).func_212873_a_();
            }
        } else {
            super.onClose();
        }
    }

    public void setStackPredicate(Predicate<ItemStack> predicate) {
        this.stackPredicate = predicate;
    }

    @Nonnull
    public ItemStack getSearchStack() {
        return this.inventory.getStackInSlot(0);
    }

    public void setSearchStack(@Nonnull ItemStack stack) {
        if (!stack.func_190926_b() && this.stackPredicate.test(stack)) {
            this.inventory.setStackInSlot(0, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
        }
    }

    public int getSlotColor(int index) {
        return super.getSlotColor(index);
    }

    protected void func_184098_a(Slot par1Slot, int par2, int par3, ClickType par4) {
        if (par1Slot != null) {
            if (par1Slot.field_75222_d == 36) {
                par1Slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                this.setSearchStack(par1Slot.func_75211_c());
            }
        }
    }

    public void tick() {
        BlockPos pos;
        List<BlockPos> posList;
        super.tick();
        this.label.setMessage("");
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (stack.func_77973_b() instanceof IPositionProvider && !(posList = ((IPositionProvider)stack.func_77973_b()).getStoredPositions(ClientUtils.getClientWorld(), stack)).isEmpty() && (pos = posList.get(0)) != null) {
            this.label.setMessage(PneumaticCraftUtils.posToString(pos));
        }
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        this.renderBackground();
        this.minecraft.func_110434_K().func_110577_a(Textures.GUI_INVENTORY_SEARCHER);
        int xStart = (this.width - this.field_146999_f) / 2;
        int yStart = (this.height - this.field_147000_g) / 2;
        this.blit(xStart, yStart, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146979_b(int par1, int par2) {
        this.font.func_211126_b("Inventory", 7.0f, 5.0f, 0x404040);
        this.font.func_211126_b("Searcher", 7.0f, 15.0f, 0x404040);
        this.font.func_211126_b("Target", 71.0f, 8.0f, 0x404040);
        for (int i = 0; i < ((ContainerInventorySearcher)this.field_147002_h).field_75151_b.size() - 1; ++i) {
            Slot slot = (Slot)((ContainerInventorySearcher)this.field_147002_h).field_75151_b.get(i);
            if (this.stackPredicate.test(slot.func_75211_c())) continue;
            RenderSystem.disableLighting();
            RenderSystem.disableDepthTest();
            int x = slot.field_75223_e;
            int y = slot.field_75221_f;
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.fillGradient(x, y, x + 16, y + 16, -1071636448, -1071636448);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.enableLighting();
            RenderSystem.enableDepthTest();
        }
    }

    public void render(int par1, int par2, float par3) {
        super.render(par1, par2, par3);
        this.func_191948_b(par1, par2);
    }
}

