/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.perk;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;

public class PerkGhostlyShape
extends Perk {
    public PerkGhostlyShape() {
        super("ghostly_shape", new ResourceLocation("tombstone", "textures/mob_effect/ghostly_shape.png"));
    }

    @Override
    public int getLevelMax() {
        return 5;
    }

    @Override
    public boolean isDisabled(@Nullable PlayerEntity player) {
        return (Integer)SharedConfigTombstone.general.ghostlyShapeDuration.get() <= 0;
    }

    @Override
    public String getTranslationKey() {
        return "effect.tombstone.ghostly_shape";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getTooltip(int level, int actualLevel, int levelWithBonus) {
        if (level == 1) {
            return "effect.tombstone.feather_fall";
        }
        if (level == 2) {
            return LangKey.MESSAGE_BREATHING.getClientTranslation(new Object[0]);
        }
        if (level == 3) {
            return "effect.tombstone.purification";
        }
        if (level == 4) {
            return "effect.tombstone.true_sight";
        }
        if (level == 5) {
            return LangKey.MESSAGE_INVULNERABLE.getClientTranslation(new Object[0]);
        }
        return "";
    }

    @Override
    public int getCost(int level) {
        return level > 0 ? 1 : 0;
    }

    @Override
    public boolean isEncrypted() {
        return true;
    }

    @Override
    public int getLevelBonus(PlayerEntity player) {
        return Helper.isDateAroundHalloween() ? 5 : 0;
    }
}

