/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.entities;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;
import xreliquary.network.PacketFXConcussiveExplosion;
import xreliquary.network.PacketHandler;
import xreliquary.util.RandHelper;

public class ConcussiveExplosion
extends Explosion {
    private World world;
    private Vec3d pos;
    Entity field_77283_e;
    private float explosionSize;
    private final Map<PlayerEntity, Vec3d> playerKnockbackMap;
    private PlayerEntity shootingEntity;

    public ConcussiveExplosion(World world, Entity entity, PlayerEntity par3Entity, Vec3d pos, float size, boolean isFlaming) {
        super(world, entity, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), size, isFlaming, Explosion.Mode.BREAK);
        this.world = world;
        this.field_77283_e = entity;
        this.shootingEntity = par3Entity;
        this.pos = pos;
        this.explosionSize = size;
        this.playerKnockbackMap = Maps.newHashMap();
    }

    public void func_77278_a() {
        float var1 = this.explosionSize;
        this.explosionSize *= 2.0f;
        List var9 = this.world.func_72839_b(this.field_77283_e, new AxisAlignedBB(this.pos.func_72441_c((double)(-this.explosionSize) - 1.0, (double)(-this.explosionSize) - 1.0, (double)(-this.explosionSize) - 1.0), this.pos.func_72441_c((double)this.explosionSize + 1.0, (double)this.explosionSize + 1.0, (double)this.explosionSize + 1.0)));
        for (Entity entity : var9) {
            if (!this.affectEntity(entity)) continue;
            this.attackEntityWithExplosion(this.pos, entity);
        }
        this.explosionSize = var1;
    }

    private void attackEntityWithExplosion(Vec3d var30, Entity entity) {
        double d9;
        double d7;
        double d5;
        double var33;
        double var13 = Math.sqrt(entity.func_195048_a(this.pos)) / (double)this.explosionSize;
        if (var13 <= 1.0 && (var33 = (double)MathHelper.func_76133_a((double)((d5 = entity.func_226277_ct_() - this.pos.func_82615_a()) * d5 + (d7 = entity.func_226278_cu_() + (double)entity.func_70047_e() - this.pos.func_82617_b()) * d7 + (d9 = entity.func_226281_cx_() - this.pos.func_82616_c()) * d9))) != 0.0) {
            double var32 = ConcussiveExplosion.func_222259_a((Vec3d)var30, (Entity)entity);
            double d10 = (1.0 - var13) * var32;
            entity.func_70097_a(DamageSource.func_76356_a((Entity)this.field_77283_e, (Entity)this.shootingEntity), (float)((int)((d10 * d10 + d10) * 6.0 * (double)(this.explosionSize * 2.0f) + 3.0)));
            entity.func_213317_d(entity.func_213322_ci().func_72441_c((d5 /= var33) * d10, (d7 /= var33) * d10, (d9 /= var33) * d10));
        }
    }

    protected boolean affectEntity(Entity entity) {
        return entity instanceof MobEntity;
    }

    public void func_77279_a(boolean spawnParticles) {
        this.world.func_184133_a(null, new BlockPos(this.pos), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + RandHelper.getRandomMinusOneToOne(this.world.field_73012_v) * 0.2f) * 0.7f);
        if (this.explosionSize >= 2.0f) {
            this.world.func_195594_a((IParticleData)ParticleTypes.field_197626_s, this.pos.func_82615_a(), this.pos.func_82617_b(), this.pos.func_82616_c(), 1.0, 0.0, 0.0);
        } else {
            this.world.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.pos.func_82615_a(), this.pos.func_82617_b(), this.pos.func_82616_c(), 1.0, 0.0, 0.0);
        }
    }

    public Map<PlayerEntity, Vec3d> func_77277_b() {
        return this.playerKnockbackMap;
    }

    public static void customBusterExplosion(Entity par1Entity, double x, double y, double z, float par8) {
        if (par1Entity.field_70170_p.field_72995_K) {
            return;
        }
        par1Entity.field_70170_p.func_217398_a(par1Entity, x, y, z, par8, false, Explosion.Mode.BREAK);
    }

    public static void customConcussiveExplosion(Entity entity, PlayerEntity player, Vec3d pos, float size, boolean isFlaming) {
        ConcussiveExplosion var11 = new ConcussiveExplosion(entity.field_70170_p, entity, player, pos, size, isFlaming);
        var11.func_77278_a();
        var11.func_77279_a(false);
        PacketHandler.sendToAllAround(new PacketFXConcussiveExplosion(size, pos), new PacketDistributor.TargetPoint(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 96.0, entity.func_130014_f_().func_201675_m().func_186058_p()));
    }

    static void grenadeConcussiveExplosion(Entity entity, PlayerEntity player, Vec3d pos) {
        GrenadeConcussiveExplosion var11 = new GrenadeConcussiveExplosion(entity.field_70170_p, entity, player, pos, 4.0f, false);
        var11.func_77278_a();
        var11.func_77279_a(false);
        PacketHandler.sendToAllAround(new PacketFXConcussiveExplosion(4.0f, pos), new PacketDistributor.TargetPoint(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 96.0, entity.func_130014_f_().func_201675_m().func_186058_p()));
    }

    public static class GrenadeConcussiveExplosion
    extends ConcussiveExplosion {
        GrenadeConcussiveExplosion(World world, Entity entity, PlayerEntity par3Entity, Vec3d pos, float size, boolean isFlaming) {
            super(world, entity, par3Entity, pos, size, isFlaming);
        }

        @Override
        protected boolean affectEntity(Entity entity) {
            return super.affectEntity(entity) && !(entity instanceof PlayerEntity) || entity instanceof PlayerEntity && this.field_77283_e.func_200201_e() != null && this.field_77283_e.func_200201_e().getString().contains(((PlayerEntity)entity).func_146103_bH().getName());
        }
    }
}

