/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityFurnaceHeater;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.ToolType;

public class BlockFurnaceHeater
extends BlockContainerImpl
implements ICustomBlockState {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.func_208617_a((double)2.0, (double)12.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), Block.func_208617_a((double)2.0, (double)2.0, (double)12.0, (double)14.0, (double)14.0, (double)16.0), Block.func_208617_a((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)4.0), Block.func_208617_a((double)12.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), Block.func_208617_a((double)0.0, (double)2.0, (double)2.0, (double)4.0, (double)14.0, (double)14.0)};

    public BlockFurnaceHeater() {
        super("furnace_heater", TileEntityFurnaceHeater::new, ModBlocks.prop(Material.field_151576_e).func_200943_b(3.0f).harvestLevel(1).harvestTool(ToolType.PICKAXE));
    }

    @Override
    protected boolean hasWaterlogging() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityFurnaceHeater && ((TileEntityFurnaceHeater)tile).isActive) {
            float z;
            float y;
            float x;
            Direction facing = (Direction)stateIn.func_177229_b((IProperty)FACING);
            if (facing == Direction.UP) {
                x = 0.35f + rand.nextFloat() * 0.3f;
                y = 0.0f;
                z = 0.35f + rand.nextFloat() * 0.3f;
            } else if (facing == Direction.DOWN) {
                x = 0.35f + rand.nextFloat() * 0.3f;
                y = 1.0f;
                z = 0.35f + rand.nextFloat() * 0.3f;
            } else {
                x = facing.func_82599_e() != 0 ? 0.35f + rand.nextFloat() * 0.3f : (facing.func_82601_c() < 0 ? 1.0f : 0.0f);
                y = 0.35f + rand.nextFloat() * 0.3f;
                z = facing.func_82601_c() != 0 ? 0.35f + rand.nextFloat() * 0.3f : (facing.func_82599_e() < 0 ? 1.0f : 0.0f);
            }
            NaturesAuraAPI.instance().spawnMagicParticle((float)pos.func_177958_n() + x, (float)pos.func_177956_o() + y, (float)pos.func_177952_p() + z, (rand.nextFloat() * 0.016f + 0.01f) * (float)facing.func_82601_c(), (rand.nextFloat() * 0.016f + 0.01f) * (float)facing.func_96559_d(), (rand.nextFloat() * 0.016f + 0.01f) * (float)facing.func_82599_e(), 16019010, rand.nextFloat() + 0.5f, 55, 0.0f, true, true);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[((Direction)state.func_177229_b((IProperty)FACING)).func_176745_a()];
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{FACING});
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a((IProperty)FACING, (Comparable)context.func_196000_l());
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.directionalBlock((Block)this, (ModelFile)generator.models().getExistingFile(generator.modLoc(this.getBaseName())));
    }
}

