/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.forms;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.forms.IFormSettings;
import thelm.jaopca.api.forms.IFormType;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.forms.FormRequest;
import thelm.jaopca.modules.ModuleData;
import thelm.jaopca.modules.ModuleHandler;

public class Form
implements IForm {
    private final IModule module;
    private final String name;
    private final IFormType type;
    private String secondaryName;
    private final EnumSet<MaterialType> materialTypes = EnumSet.allOf(MaterialType.class);
    private final TreeSet<String> defaultMaterialBlacklist = new TreeSet();
    private final TreeSet<String> materialBlacklist = new TreeSet();
    private final TreeSet<String> materialWhitelist = new TreeSet();
    private IFormSettings settings;
    private boolean skipGroupCheck = false;
    private boolean locked = false;
    private IFormRequest request;
    private final TreeSet<IMaterial> materials = new TreeSet();

    public Form(IModule module, String name, IFormType type) {
        this.module = Objects.requireNonNull(module);
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
        this.secondaryName = name;
        this.settings = type.getNewSettings();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IFormType getType() {
        return this.type;
    }

    @Override
    public IModule getModule() {
        return this.module;
    }

    @Override
    public IForm setSecondaryName(String secondaryName) {
        if (!this.locked) {
            this.secondaryName = secondaryName;
        }
        return this;
    }

    @Override
    public String getSecondaryName() {
        return this.secondaryName;
    }

    @Override
    public IForm setMaterialTypes(Collection<MaterialType> materialTypes) {
        if (!this.locked) {
            this.materialTypes.clear();
            this.materialTypes.addAll(materialTypes);
        }
        return this;
    }

    @Override
    public IForm setMaterialTypes(MaterialType ... materialTypes) {
        if (!this.locked) {
            this.materialTypes.clear();
            Collections.addAll(this.materialTypes, materialTypes);
        }
        return this;
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return Collections.unmodifiableSet(this.materialTypes);
    }

    @Override
    public IForm setDefaultMaterialBlacklist(Collection<String> defaultMaterialBlacklist) {
        if (!this.locked) {
            this.defaultMaterialBlacklist.clear();
            this.defaultMaterialBlacklist.addAll(defaultMaterialBlacklist);
        }
        return this;
    }

    @Override
    public IForm setDefaultMaterialBlacklist(String ... defaultMaterialBlacklist) {
        if (!this.locked) {
            this.defaultMaterialBlacklist.clear();
            Collections.addAll(this.defaultMaterialBlacklist, defaultMaterialBlacklist);
        }
        return this;
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return Collections.unmodifiableNavigableSet(this.defaultMaterialBlacklist);
    }

    @Override
    public IForm setSettings(IFormSettings settings) {
        if (!this.locked && settings.getType() == this.type) {
            this.settings = settings;
        }
        return this;
    }

    @Override
    public IFormSettings getSettings() {
        return this.settings;
    }

    @Override
    public IForm setSkipGroupedCheck(boolean skipGroupCheck) {
        if (!this.locked) {
            this.skipGroupCheck = skipGroupCheck;
        }
        return this;
    }

    @Override
    public boolean skipGroupedCheck() {
        return this.skipGroupCheck;
    }

    @Override
    public Set<IMaterial> getMaterials() {
        return Collections.unmodifiableNavigableSet(this.materials);
    }

    @Override
    public IForm lock() {
        this.locked = true;
        return this;
    }

    @Override
    public IFormRequest toRequest() {
        FormRequest request = new FormRequest(this.module, this);
        this.setRequest(request);
        return request;
    }

    @Override
    public IForm setRequest(IFormRequest request) {
        if (request.getForms().contains(this)) {
            this.request = request;
        }
        return this;
    }

    @Override
    public boolean isMaterialValid(IMaterial material) {
        ModuleData data = ModuleHandler.getModuleData(this.module);
        return this.materialTypes.contains((Object)material.getType()) && !this.defaultMaterialBlacklist.contains(material.getName()) && !material.getConfigModuleBlacklist().contains(this.module.getName()) && !data.getConfigMaterialBlacklist().contains(material.getName()) && this.type.shouldRegister(this, material) && !data.getRejectedMaterials().contains(material) && (!this.module.isPassive() || data.getConfigPassiveMaterialWhitelist().contains(material.getName()) || data.getRequestedMaterials().contains(material));
    }

    @Override
    public void setMaterials(Collection<IMaterial> materials) {
        this.materials.clear();
        this.materials.addAll(materials);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Form:" + this.name;
    }
}

