/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energizing;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;
import owmii.lib.block.AbstractBlock;
import owmii.lib.block.AbstractEnergyBlock;
import owmii.lib.client.handler.IHud;
import owmii.lib.client.util.Draw;
import owmii.lib.config.IEnergyConfig;
import owmii.lib.energy.Energy;
import owmii.lib.util.IVariant;
import owmii.lib.util.Text;
import owmii.lib.util.math.V3d;
import owmii.powah.api.wrench.IWrenchable;
import owmii.powah.api.wrench.WrenchMode;
import owmii.powah.block.Tier;
import owmii.powah.block.energizing.EnergizingOrbTile;
import owmii.powah.block.energizing.EnergizingRodTile;
import owmii.powah.config.Configs;
import owmii.powah.item.WrenchItem;

public class EnergizingRodBlock
extends AbstractEnergyBlock<Tier>
implements IWaterLoggable,
IWrenchable,
IHud {
    private static final Map<Direction, VoxelShape> VOXEL_SHAPES = new HashMap<Direction, VoxelShape>();

    public EnergizingRodBlock(Block.Properties properties, Tier variant) {
        super(properties, (IVariant)variant);
        this.setStateProps(state -> {
            BlockState cfr_ignored_0 = (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)Direction.DOWN);
        });
    }

    public int stackSize() {
        return 1;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VOXEL_SHAPES.get(state.func_177229_b((IProperty)FACING));
    }

    public IEnergyConfig<Tier> getEnergyConfig() {
        return Configs.ENERGIZING;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new EnergizingRodTile((Tier)this.variant);
    }

    protected boolean checkValidEnergySide() {
        return true;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(state, worldIn, pos, oldState, isMoving);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof EnergizingRodTile) {
            this.setOrbPos(worldIn, pos, (EnergizingRodTile)tileEntity);
        }
    }

    public void setOrbPos(World worldIn, BlockPos pos, EnergizingRodTile tile) {
        int range = (Integer)Configs.ENERGIZING.range.get();
        List list = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-range, -range, -range), (BlockPos)pos.func_177982_a(range, range, range)).map(BlockPos::func_185334_h).collect(Collectors.toList());
        for (BlockPos pos1 : list) {
            TileEntity tileEntity1;
            if (pos1.equals((Object)BlockPos.field_177992_a) || !((tileEntity1 = worldIn.func_175625_s(pos1)) instanceof EnergizingOrbTile)) continue;
            tile.setOrbPos(pos1);
            break;
        }
    }

    protected AbstractBlock.Facing getFacing() {
        return AbstractBlock.Facing.ALL;
    }

    @Override
    public boolean onWrench(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, Direction side, WrenchMode mode, Vec3d hit) {
        ItemStack stack;
        if (mode.link() && (stack = player.func_184586_b(hand)).func_77973_b() instanceof WrenchItem) {
            WrenchItem wrench = (WrenchItem)stack.func_77973_b();
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof EnergizingRodTile) {
                EnergizingRodTile rod = (EnergizingRodTile)tileEntity;
                CompoundNBT nbt = wrench.getWrenchNBT(stack);
                if (nbt.func_150297_b("OrbPos", 10)) {
                    BlockPos orbPos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("OrbPos"));
                    TileEntity tileEntity1 = world.func_175625_s(orbPos);
                    if (tileEntity1 instanceof EnergizingOrbTile) {
                        EnergizingOrbTile orb = (EnergizingOrbTile)tileEntity1;
                        V3d v3d = V3d.from((Vec3i)orbPos);
                        if ((int)v3d.distance((Vec3i)pos) <= (Integer)Configs.ENERGIZING.range.get()) {
                            rod.setOrbPos(orbPos);
                            player.func_146105_b(new TranslationTextComponent("chat.powah.wrench.link.done", new Object[0]).func_211708_a(TextFormatting.GOLD), true);
                        } else {
                            player.func_146105_b(new TranslationTextComponent("chat.powah.wrench.link.fail", new Object[0]).func_211708_a(TextFormatting.RED), true);
                        }
                    }
                    nbt.func_82580_o("OrbPos");
                } else {
                    nbt.func_218657_a("RodPos", (INBT)NBTUtil.func_186859_a((BlockPos)pos));
                    player.func_146105_b(new TranslationTextComponent("chat.powah.wrench.link.start", new Object[0]).func_211708_a(TextFormatting.YELLOW), true);
                }
                return true;
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean renderHud(BlockState state, World world, BlockPos pos, PlayerEntity player, BlockRayTraceResult result, @Nullable TileEntity te) {
        if (te instanceof EnergizingRodTile) {
            EnergizingRodTile rod = (EnergizingRodTile)te;
            RenderSystem.pushMatrix();
            RenderSystem.enableBlend();
            Minecraft mc = Minecraft.func_71410_x();
            FontRenderer font = mc.field_71466_p;
            int x = mc.func_228018_at_().func_198107_o() / 2;
            int y = mc.func_228018_at_().func_198087_p();
            String s = TextFormatting.GRAY + I18n.func_135052_a((String)"info.lollipop.stored.energy.fe", (Object[])new Object[]{Text.addCommas((long)rod.getEnergyStored()), Text.numFormat((long)rod.getEnergyCapacity())});
            mc.func_110434_K().func_110577_a(new ResourceLocation("lollipop", "textures/gui/ov_energy.png"));
            GuiUtils.drawTexturedModalRect((int)(x - 37 - 1), (int)(y - 80), (int)0, (int)0, (int)74, (int)9, (float)0.0f);
            Draw.gaugeH((int)(x - 37), (int)(y - 79), (int)72, (int)16, (int)0, (int)9, (Energy)((EnergizingRodTile)te).getEnergyStorage());
            font.func_175063_a(s, (float)x - (float)font.func_78256_a(s) / 2.0f, (float)(y - 67), 0xFFFFFF);
            RenderSystem.disableBlend();
            RenderSystem.popMatrix();
        }
        return true;
    }

    static {
        VOXEL_SHAPES.put(Direction.UP, VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0), (VoxelShape)VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)13.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape)EnergizingRodBlock.func_208617_a((double)7.25, (double)9.0, (double)7.25, (double)8.75, (double)13.0, (double)8.75), (IBooleanFunction)IBooleanFunction.field_223244_o_), (IBooleanFunction)IBooleanFunction.field_223244_o_));
        VOXEL_SHAPES.put(Direction.DOWN, VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0), (VoxelShape)VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)3.0, (double)9.0), (VoxelShape)EnergizingRodBlock.func_208617_a((double)7.25, (double)3.0, (double)7.25, (double)8.75, (double)7.0, (double)8.75), (IBooleanFunction)IBooleanFunction.field_223244_o_), (IBooleanFunction)IBooleanFunction.field_223244_o_));
        VOXEL_SHAPES.put(Direction.NORTH, VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0), (VoxelShape)VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)3.0), (VoxelShape)EnergizingRodBlock.func_208617_a((double)7.25, (double)7.25, (double)3.0, (double)8.75, (double)8.75, (double)7.0), (IBooleanFunction)IBooleanFunction.field_223244_o_), (IBooleanFunction)IBooleanFunction.field_223244_o_));
        VOXEL_SHAPES.put(Direction.SOUTH, VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0), (VoxelShape)VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)7.0, (double)13.0, (double)9.0, (double)9.0, (double)16.0), (VoxelShape)EnergizingRodBlock.func_208617_a((double)7.25, (double)7.25, (double)13.0, (double)8.75, (double)8.75, (double)9.0), (IBooleanFunction)IBooleanFunction.field_223244_o_), (IBooleanFunction)IBooleanFunction.field_223244_o_));
        VOXEL_SHAPES.put(Direction.WEST, VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0), (VoxelShape)VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)0.0, (double)7.0, (double)7.0, (double)3.0, (double)9.0, (double)9.0), (VoxelShape)EnergizingRodBlock.func_208617_a((double)3.0, (double)7.25, (double)7.25, (double)7.0, (double)8.75, (double)8.75), (IBooleanFunction)IBooleanFunction.field_223244_o_), (IBooleanFunction)IBooleanFunction.field_223244_o_));
        VOXEL_SHAPES.put(Direction.EAST, VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0), (VoxelShape)VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)13.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0), (VoxelShape)EnergizingRodBlock.func_208617_a((double)13.0, (double)7.25, (double)7.25, (double)9.0, (double)8.75, (double)8.75), (IBooleanFunction)IBooleanFunction.field_223244_o_), (IBooleanFunction)IBooleanFunction.field_223244_o_));
    }
}

