/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.endergate;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import owmii.lib.block.AbstractBlock;
import owmii.lib.config.IEnergyConfig;
import owmii.powah.block.Tier;
import owmii.powah.block.endercell.EnderCellBlock;
import owmii.powah.block.endergate.EnderGateTile;
import owmii.powah.config.Configs;

public class EnderGateBlock
extends EnderCellBlock {
    private static final Map<Direction, VoxelShape> SHAPES = new HashMap<Direction, VoxelShape>();

    public EnderGateBlock(Block.Properties properties, Tier variant) {
        super(properties, variant);
        this.setDefaultState();
    }

    @Override
    public IEnergyConfig<Tier> getEnergyConfig() {
        return Configs.ENDER_GATE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPES.get(state.func_177229_b((IProperty)FACING));
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new EnderGateTile((Tier)this.variant);
    }

    protected boolean checkValidEnergySide() {
        return true;
    }

    protected AbstractBlock.Facing getFacing() {
        return AbstractBlock.Facing.ALL;
    }

    static {
        SHAPES.put(Direction.UP, EnderGateBlock.func_208617_a((double)6.0, (double)15.5, (double)6.0, (double)10.0, (double)16.0, (double)10.0));
        SHAPES.put(Direction.DOWN, EnderGateBlock.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)0.5, (double)10.0));
        SHAPES.put(Direction.NORTH, EnderGateBlock.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)0.5));
        SHAPES.put(Direction.SOUTH, EnderGateBlock.func_208617_a((double)6.0, (double)6.0, (double)15.5, (double)10.0, (double)10.0, (double)16.0));
        SHAPES.put(Direction.EAST, EnderGateBlock.func_208617_a((double)15.5, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0));
        SHAPES.put(Direction.WEST, EnderGateBlock.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)0.5, (double)10.0, (double)10.0));
    }
}

