/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.network;

import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.manager.DimStorageManager;
import edivad.dimstorage.storage.DimTankStorage;
import net.minecraftforge.fluids.FluidStack;

public abstract class TankState {
    public Frequency frequency;
    public FluidStack clientLiquid = FluidStack.EMPTY;
    public FluidStack serverLiquid = FluidStack.EMPTY;

    public void setFrequency(Frequency frequency) {
        this.frequency = frequency;
    }

    public void update(boolean client) {
        FluidStack succ;
        FluidStack prec;
        if (client) {
            prec = this.clientLiquid.copy();
            succ = this.clientLiquid = this.serverLiquid.copy();
        } else {
            prec = this.serverLiquid.copy();
            succ = this.serverLiquid = this.getFluidStorageServer();
            this.sendSyncPacket();
            this.clientLiquid = this.serverLiquid.copy();
        }
        if (prec.getAmount() == 0 != (succ.getAmount() == 0) || !prec.isFluidEqual(succ)) {
            this.onLiquidChanged();
        }
    }

    public void onLiquidChanged() {
    }

    public abstract void sendSyncPacket();

    public void sync(FluidStack liquid) {
        this.serverLiquid = liquid;
    }

    private FluidStack getFluidStorageServer() {
        return ((DimTankStorage)DimStorageManager.instance(false).getStorage(this.frequency, "fluid")).getFluidInTank(0);
    }
}

