/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.world.gen;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.VineBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

public class RatsStructureVineProcessor
extends StructureProcessor {
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.WEST, Direction.SOUTH};
    private static final BlockState VINE = Blocks.field_150395_bd.func_176223_P();
    private float integrity = 1.0f;

    public RatsStructureVineProcessor(float integrity) {
        this.integrity = integrity;
    }

    public Template.BlockInfo func_215194_a(IWorldReader worldIn, BlockPos pos, Template.BlockInfo blockInfoIn, Template.BlockInfo blockInfoIn2, PlacementSettings settings) {
        Random random = settings.func_189947_a(pos);
        if (blockInfoIn.field_186243_b.func_185904_a().func_76222_j()) {
            for (Direction offsetDir : HORIZONTALS) {
                BlockPos offsetPos = pos.func_177972_a(offsetDir);
                if (!worldIn.func_180495_p(offsetPos).func_200015_d((IBlockReader)worldIn, offsetPos)) continue;
                for (Direction secondOffset : HORIZONTALS) {
                    if (worldIn.func_180495_p(offsetPos.func_177972_a(secondOffset)).func_200015_d((IBlockReader)worldIn, offsetPos) || random.nextInt(8) != 0) continue;
                    Direction opposFacing = secondOffset.func_176734_d();
                    BlockState vineState = (BlockState)((BlockState)((BlockState)((BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((IProperty)VineBlock.field_176273_b, (Comparable)Boolean.valueOf(opposFacing == Direction.NORTH))).func_206870_a((IProperty)VineBlock.field_176278_M, (Comparable)Boolean.valueOf(opposFacing == Direction.EAST))).func_206870_a((IProperty)VineBlock.field_176279_N, (Comparable)Boolean.valueOf(opposFacing == Direction.SOUTH))).func_206870_a((IProperty)VineBlock.field_176280_O, (Comparable)Boolean.valueOf(opposFacing == Direction.WEST));
                    return new Template.BlockInfo(pos, vineState, null);
                }
            }
        }
        return blockInfoIn;
    }

    protected IStructureProcessorType func_215192_a() {
        return IStructureProcessorType.field_214921_c;
    }

    protected <T> Dynamic<T> func_215193_a(DynamicOps<T> ops) {
        return new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("rats_processor"), (Object)ops.createFloat(this.integrity))));
    }
}

