/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.blocks.ICustomRendered;
import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemRatTube
extends Item
implements ICustomRendered {
    public DyeColor color;

    public ItemRatTube(DyeColor color) {
        super(new Item.Properties().func_200916_a(RatsMod.TAB));
        this.setRegistryName("rats", "rat_tube_" + color.func_176610_l());
        this.color = color;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(new TranslationTextComponent("block.rats.rat_tube.desc0", new Object[0]).func_211708_a(TextFormatting.GRAY));
        tooltip.add(new TranslationTextComponent("block.rats.rat_tube.desc1", new Object[0]).func_211708_a(TextFormatting.GRAY));
        tooltip.add(new TranslationTextComponent("block.rats.rat_tube.desc2", new Object[0]).func_211708_a(TextFormatting.GRAY));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ActionResultType actionresulttype = this.tryPlace(new BlockItemUseContext(context));
        return actionresulttype != ActionResultType.SUCCESS && this.func_219971_r() ? this.func_77659_a(context.func_195991_k(), context.func_195999_j(), context.func_221531_n()).func_188397_a() : actionresulttype;
    }

    public ActionResultType tryPlace(BlockItemUseContext context) {
        if (!context.func_196011_b()) {
            return ActionResultType.FAIL;
        }
        BlockItemUseContext blockitemusecontext = this.getBlockItemUseContext(context);
        if (blockitemusecontext == null) {
            return ActionResultType.FAIL;
        }
        BlockState blockstate = this.getStateForPlacement(blockitemusecontext);
        if (blockstate == null) {
            return ActionResultType.FAIL;
        }
        if (!this.placeBlock(blockitemusecontext, blockstate)) {
            return ActionResultType.FAIL;
        }
        BlockPos blockpos = blockitemusecontext.func_195995_a();
        World world = blockitemusecontext.func_195991_k();
        PlayerEntity playerentity = blockitemusecontext.func_195999_j();
        ItemStack itemstack = blockitemusecontext.func_195996_i();
        BlockState blockstate1 = world.func_180495_p(blockpos);
        Block block = blockstate1.func_177230_c();
        if (block == blockstate.func_177230_c()) {
            blockstate1 = this.func_219985_a(blockpos, world, itemstack, blockstate1);
            this.onBlockPlaced(blockpos, world, playerentity, itemstack, blockstate1);
            block.func_180633_a(world, blockpos, blockstate1, (LivingEntity)playerentity, itemstack);
            if (playerentity instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)playerentity, blockpos, itemstack);
            }
        }
        SoundType soundtype = blockstate1.getSoundType((IWorldReader)world, blockpos, (Entity)context.func_195999_j());
        world.func_184133_a(playerentity, blockpos, this.getPlaceSound(blockstate1), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        itemstack.func_190918_g(1);
        return ActionResultType.SUCCESS;
    }

    protected SoundEvent getPlaceSound(BlockState state) {
        return state.func_215695_r().func_185841_e();
    }

    @Nullable
    public BlockItemUseContext getBlockItemUseContext(BlockItemUseContext context) {
        return context;
    }

    protected boolean onBlockPlaced(BlockPos pos, World worldIn, @Nullable PlayerEntity player, ItemStack stack, BlockState state) {
        return ItemRatTube.setTileEntityNBT(worldIn, player, pos, stack);
    }

    @Nullable
    protected BlockState getStateForPlacement(BlockItemUseContext context) {
        BlockState blockstate = RatsBlockRegistry.RAT_TUBE_COLOR.func_196258_a(context);
        return blockstate != null && this.canPlace(context, blockstate) ? blockstate : null;
    }

    private BlockState func_219985_a(BlockPos p_219985_1_, World p_219985_2_, ItemStack p_219985_3_, BlockState p_219985_4_) {
        BlockState blockstate = p_219985_4_;
        CompoundNBT compoundnbt = p_219985_3_.func_77978_p();
        if (compoundnbt != null) {
            CompoundNBT compoundnbt1 = compoundnbt.func_74775_l("BlockStateTag");
            StateContainer statecontainer = p_219985_4_.func_177230_c().func_176194_O();
            for (String s : compoundnbt1.func_150296_c()) {
                IProperty iproperty = statecontainer.func_185920_a(s);
                if (iproperty == null) continue;
                String s1 = compoundnbt1.func_74781_a(s).func_150285_a_();
                blockstate = ItemRatTube.func_219988_a(blockstate, iproperty, s1);
            }
        }
        if (blockstate != p_219985_4_) {
            p_219985_2_.func_180501_a(p_219985_1_, blockstate, 2);
        }
        return blockstate;
    }

    private static <T extends Comparable<T>> BlockState func_219988_a(BlockState p_219988_0_, IProperty<T> p_219988_1_, String p_219988_2_) {
        return p_219988_1_.func_185929_b(p_219988_2_).map(p_219986_2_ -> (BlockState)p_219988_0_.func_206870_a(p_219988_1_, p_219986_2_)).orElse(p_219988_0_);
    }

    protected boolean canPlace(BlockItemUseContext p_195944_1_, BlockState p_195944_2_) {
        PlayerEntity playerentity = p_195944_1_.func_195999_j();
        ISelectionContext iselectioncontext = playerentity == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a((Entity)playerentity);
        return !this.func_219987_d() || p_195944_2_.func_196955_c((IWorldReader)p_195944_1_.func_195991_k(), p_195944_1_.func_195995_a());
    }

    protected boolean func_219987_d() {
        return true;
    }

    protected boolean placeBlock(BlockItemUseContext context, BlockState state) {
        return context.func_195991_k().func_180501_a(context.func_195995_a(), state, 11);
    }

    public static boolean setTileEntityNBT(World worldIn, @Nullable PlayerEntity player, BlockPos pos, ItemStack stackIn) {
        TileEntity tileentity;
        MinecraftServer minecraftserver = worldIn.func_73046_m();
        if (minecraftserver == null) {
            return false;
        }
        CompoundNBT compoundnbt = stackIn.func_179543_a("BlockEntityTag");
        if (compoundnbt != null && (tileentity = worldIn.func_175625_s(pos)) != null) {
            if (!(worldIn.field_72995_K || !tileentity.func_183000_F() || player != null && player.func_195070_dx())) {
                return false;
            }
            CompoundNBT compoundnbt1 = tileentity.func_189515_b(new CompoundNBT());
            CompoundNBT compoundnbt2 = compoundnbt1.func_74737_b();
            compoundnbt1.func_197643_a(compoundnbt);
            compoundnbt1.func_74768_a("x", pos.func_177958_n());
            compoundnbt1.func_74768_a("y", pos.func_177956_o());
            compoundnbt1.func_74768_a("z", pos.func_177952_p());
            if (!compoundnbt1.equals((Object)compoundnbt2)) {
                tileentity.func_145839_a(compoundnbt1);
                tileentity.func_70296_d();
                return true;
            }
        }
        return false;
    }
}

