/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.blocks;

import com.github.alexthe666.rats.server.entity.tile.TileEntityDutchratBell;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import javax.annotation.Nullable;
import net.minecraft.block.BellBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BellAttachment;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockDutchratBell
extends BellBlock {
    public BlockDutchratBell() {
        super(Block.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151647_F).func_200943_b(5.0f).func_200947_a(SoundType.field_185858_k));
        this.setRegistryName("rats:dutchrat_bell");
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_220133_a, (Comparable)Direction.NORTH)).func_206870_a((IProperty)BlockStateProperties.field_222511_P, (Comparable)BellAttachment.FLOOR)).func_206870_a((IProperty)field_226883_b_, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_226884_a_(World p_226884_1_, BlockState p_226884_2_, BlockRayTraceResult p_226884_3_, @Nullable PlayerEntity p_226884_4_, boolean p_226884_5_) {
        boolean flag;
        Direction direction = p_226884_3_.func_216354_b();
        BlockPos blockpos = p_226884_3_.func_216350_a();
        boolean bl = flag = !p_226884_5_ || this.canRingFrom(p_226884_2_, direction, p_226884_3_.func_216347_e().field_72448_b - (double)blockpos.func_177956_o());
        if (flag) {
            boolean flag1 = this.func_226885_a_(p_226884_1_, blockpos, direction);
            if (flag1 && p_226884_4_ != null) {
                p_226884_4_.func_195066_a(Stats.field_219740_ax);
            }
            return true;
        }
        return false;
    }

    public boolean func_226885_a_(World p_226885_1_, BlockPos p_226885_2_, @Nullable Direction p_226885_3_) {
        TileEntity tileentity = p_226885_1_.func_175625_s(p_226885_2_);
        if (!p_226885_1_.field_72995_K && tileentity instanceof TileEntityDutchratBell) {
            if (p_226885_3_ == null) {
                p_226885_3_ = (Direction)p_226885_1_.func_180495_p(p_226885_2_).func_177229_b((IProperty)field_220133_a);
            }
            this.playRingSound(p_226885_1_, p_226885_2_);
            ((TileEntityDutchratBell)tileentity).func_213939_a(p_226885_3_);
            return true;
        }
        return false;
    }

    private boolean canRingFrom(BlockState p_220129_1_, Direction p_220129_2_, double p_220129_3_) {
        if (p_220129_2_.func_176740_k() != Direction.Axis.Y && !(p_220129_3_ > (double)0.8124f)) {
            Direction direction = (Direction)p_220129_1_.func_177229_b((IProperty)field_220133_a);
            BellAttachment bellattachment = (BellAttachment)p_220129_1_.func_177229_b((IProperty)BlockStateProperties.field_222511_P);
            switch (bellattachment) {
                case FLOOR: {
                    return direction.func_176740_k() == p_220129_2_.func_176740_k();
                }
                case SINGLE_WALL: 
                case DOUBLE_WALL: {
                    return direction.func_176740_k() != p_220129_2_.func_176740_k();
                }
                case CEILING: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private void playRingSound(World worldIn, BlockPos pos) {
        if (worldIn.func_72935_r()) {
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_219603_Y, SoundCategory.BLOCKS, 2.0f, 1.0f);
        } else {
            worldIn.func_184133_a((PlayerEntity)null, pos, RatsSoundRegistry.DUTCHRAT_BELL, SoundCategory.BLOCKS, 2.0f, 1.0f);
        }
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityDutchratBell();
    }
}

