/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.entity;

import com.github.alexthe666.rats.client.model.ModelEmpty;
import com.github.alexthe666.rats.client.model.ModelRatKing;
import com.github.alexthe666.rats.server.entity.EntityRatKing;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.LightType;

public class LayerRatKing
extends LayerRenderer<EntityRatKing, ModelEmpty<EntityRatKing>> {
    private static final RenderType TEXTURE_EYES = RenderType.func_228652_i_((ResourceLocation)new ResourceLocation("rats:textures/entity/rat/rat_eye_glow.png"));
    private static final RenderType TEXTURE_0 = RenderType.func_228640_c_((ResourceLocation)new ResourceLocation("rats:textures/entity/rat/rat_blue.png"));
    private static final RenderType TEXTURE_1 = RenderType.func_228640_c_((ResourceLocation)new ResourceLocation("rats:textures/entity/rat/rat_black.png"));
    private static final RenderType TEXTURE_2 = RenderType.func_228640_c_((ResourceLocation)new ResourceLocation("rats:textures/entity/rat/rat_brown.png"));
    private static final RenderType TEXTURE_3 = RenderType.func_228640_c_((ResourceLocation)new ResourceLocation("rats:textures/entity/rat/rat_green.png"));
    private final IEntityRenderer<EntityRatKing, ModelEmpty<EntityRatKing>> ratRenderer;
    private final ModelRatKing RAT_MODEL = new ModelRatKing(0);

    public LayerRatKing(IEntityRenderer<EntityRatKing, ModelEmpty<EntityRatKing>> ratRendererIn) {
        super(ratRendererIn);
        this.ratRenderer = ratRendererIn;
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, EntityRatKing king, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = MathHelper.func_219805_h((float)partialTicks, (float)king.field_70760_ar, (float)king.field_70761_aq);
        float f1 = MathHelper.func_219805_h((float)partialTicks, (float)king.field_70758_at, (float)king.field_70759_as);
        float f2 = f1 - f;
        long roundedTime = king.field_70170_p.func_72820_D() % 24000L;
        boolean night = roundedTime >= 13000L && roundedTime <= 22000L;
        BlockPos ratPos = king.getLightPosition();
        int brightI = king.field_70170_p.func_226658_a_(LightType.SKY, ratPos);
        int brightJ = king.field_70170_p.func_226658_a_(LightType.BLOCK, ratPos);
        int brightness = night ? brightJ : Math.max(brightI, brightJ);
        for (int i = 0; i < 15; ++i) {
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(this.getRatTexture(king.getRatColors(i)));
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)i * 24.0f));
            matrixStackIn.func_227861_a_(0.0, 0.6, -0.8);
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227862_a_(0.6f, 0.6f, 0.6f);
            this.RAT_MODEL.func_225597_a_(king, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            this.RAT_MODEL.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, LivingRenderer.func_229117_c_((LivingEntity)king, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            if (brightness < 7) {
                IVertexBuilder iGlowBuffer = bufferIn.getBuffer(TEXTURE_EYES);
                this.RAT_MODEL.func_225598_a_(matrixStackIn, iGlowBuffer, packedLightIn, LivingRenderer.func_229117_c_((LivingEntity)king, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            }
            matrixStackIn.func_227865_b_();
            matrixStackIn.func_227865_b_();
        }
    }

    private RenderType getRatTexture(int textureIndex) {
        switch (textureIndex) {
            case 1: {
                return TEXTURE_1;
            }
            case 2: {
                return TEXTURE_2;
            }
            case 3: {
                return TEXTURE_3;
            }
        }
        return TEXTURE_0;
    }

    public boolean shouldCombineTextures() {
        return false;
    }
}

