/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.gui;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.client.gui.ChangeCommandButton;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatCraftingTable;
import com.github.alexthe666.rats.server.inventory.ContainerRatCraftingTable;
import com.github.alexthe666.rats.server.message.MessageIncreaseRatRecipe;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiRatCraftingTable
extends ContainerScreen<ContainerRatCraftingTable> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("rats:textures/gui/rat_crafting_table.png");
    private final PlayerInventory playerInventory;
    private final IInventory tileFurnace;

    public GuiRatCraftingTable(ContainerRatCraftingTable container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.playerInventory = inv;
        this.tileFurnace = container.tileRatCraftingTable;
        this.field_147000_g = 211;
    }

    public void init() {
        super.init();
        this.buttons.clear();
        int i = (this.width - 248) / 2;
        int j = (this.height - 166) / 2;
        this.addButton((Widget)new ChangeCommandButton(1, i + 43, j + 56, false, p_214132_1_ -> {
            if (RatsMod.PROXY.getRefrencedTE() instanceof TileEntityRatCraftingTable) {
                TileEntityRatCraftingTable ratTable = (TileEntityRatCraftingTable)RatsMod.PROXY.getRefrencedTE();
                ratTable.decreaseRecipe();
                RatsMod.NETWORK_WRAPPER.sendToServer((Object)new MessageIncreaseRatRecipe(((TileEntityRatCraftingTable)RatsMod.PROXY.getRefrencedTE()).func_174877_v().func_218275_a(), false));
            }
        }));
        this.addButton((Widget)new ChangeCommandButton(2, i + 198, j + 56, true, p_214132_1_ -> {
            if (RatsMod.PROXY.getRefrencedTE() instanceof TileEntityRatCraftingTable) {
                TileEntityRatCraftingTable ratTable = (TileEntityRatCraftingTable)RatsMod.PROXY.getRefrencedTE();
                ratTable.increaseRecipe();
                RatsMod.NETWORK_WRAPPER.sendToServer((Object)new MessageIncreaseRatRecipe(((TileEntityRatCraftingTable)RatsMod.PROXY.getRefrencedTE()).func_174877_v().func_218275_a(), true));
            }
        }));
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String ratDesc;
        String s = this.getTitle().func_150254_d();
        this.font.func_211126_b(s, (float)(this.field_146999_f / 2 - this.font.func_78256_a(s) / 2), 5.0f, 0x404040);
        this.font.func_211126_b(this.playerInventory.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 94 + 2), 0x404040);
        this.font.func_211126_b(I18n.func_135052_a((String)"container.rat_crafting_table.required", (Object[])new Object[0]), 8.0f, (float)(this.field_147000_g - 163 + 2), 0x404040);
        this.font.func_211126_b(I18n.func_135052_a((String)"container.rat_crafting_table.input", (Object[])new Object[0]), 8.0f, (float)(this.field_147000_g - 123 + 2), 0x404040);
        int screenW = (this.width - 248) / 2;
        int screenH = (this.height - 166) / 2;
        ArrayList<ItemStack> drawnIngredients = new ArrayList<ItemStack>();
        if (RatsMod.PROXY.getRefrencedTE() instanceof TileEntityRatCraftingTable) {
            IRecipe recipe = ((TileEntityRatCraftingTable)RatsMod.PROXY.getRefrencedTE()).getSelectedRecipe();
            int renderingIndex = 0;
            if (recipe != null) {
                for (int i = 0; i < recipe.func_192400_c().size(); ++i) {
                    Ingredient ingredient = (Ingredient)recipe.func_192400_c().get(i);
                    ItemStack[] matches = ingredient.func_193365_a();
                    int index = 0;
                    if (matches.length > 1) {
                        index = this.playerInventory.field_70458_d.field_70173_aa / 20 % matches.length;
                    }
                    if (matches.length <= 0) continue;
                    ItemStack drawn = matches[index].func_77946_l();
                    int count = 0;
                    if (this.doesListContainStack(drawnIngredients, drawn) || drawn.func_190926_b() || drawn.func_77973_b() == Items.field_190931_a) continue;
                    for (int j = 0; j < recipe.func_192400_c().size(); ++j) {
                        if (!this.doesArrayContainStack(((Ingredient)recipe.func_192400_c().get(j)).func_193365_a(), drawn)) continue;
                        ++count;
                    }
                    drawn.func_190920_e(count);
                    drawnIngredients.add(drawn);
                    GlStateManager.func_227716_f_();
                    GlStateManager.func_227734_k_();
                    GlStateManager.func_227623_K_();
                    this.drawRecipeItemStack(drawn, 8 + renderingIndex * 18, 60);
                    ++renderingIndex;
                }
            }
        }
        if (mouseX > screenW + 32 && mouseX < screenW + 70 && mouseY > screenH - 15 && mouseY < screenH + 24) {
            ratDesc = I18n.func_135052_a((String)"container.rat_crafting_table.rat_desc", (Object[])new Object[0]);
            this.renderTooltip(Arrays.asList(ratDesc), mouseX - screenW - 40, mouseY - screenH + 10, this.font);
        }
        if (mouseX > screenW + 69 && mouseX < screenW + 87 && mouseY > screenH - 7 && mouseY < screenH + 15 && this.tileFurnace.func_70301_a(0).func_190926_b()) {
            ratDesc = I18n.func_135052_a((String)"container.rat_crafting_table.input_desc", (Object[])new Object[0]);
            this.renderTooltip(Arrays.asList(ratDesc), mouseX - screenW - 40, mouseY - screenH + 10, this.font);
        }
    }

    private boolean doesListContainStack(List<ItemStack> list, ItemStack stack) {
        for (ItemStack currentItem : list) {
            if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)currentItem)) continue;
            return true;
        }
        return false;
    }

    private boolean doesArrayContainStack(ItemStack[] list, ItemStack stack) {
        for (ItemStack currentItem : list) {
            if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)currentItem)) continue;
            return true;
        }
        return false;
    }

    private void drawRecipeItemStack(ItemStack stack, int x, int y) {
        if (this.font == null) {
            this.font = this.font;
        }
        this.itemRenderer.func_180450_b(stack, x, y);
        this.itemRenderer.func_180453_a(this.font, stack, x, y, null);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(TEXTURE);
        int i = (this.width - this.field_146999_f) / 2;
        int j = (this.height - this.field_147000_g) / 2;
        this.blit(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        int l = ((ContainerRatCraftingTable)this.field_147002_h).getCookProgressScaled(64);
        this.blit(i + 54, j + 21, 0, 211, l, 16);
        if (RatsMod.PROXY.getRefrencedTE() instanceof TileEntityRatCraftingTable && ((TileEntityRatCraftingTable)RatsMod.PROXY.getRefrencedTE()).hasRat) {
            this.blit(i + 9, j, 176, 0, 21, 21);
        } else {
            this.blit(i + 8, j + 15, 198, 0, 21, 21);
        }
    }

    public boolean shouldRenderButtons() {
        return RatsMod.PROXY.getRefrencedTE() instanceof TileEntityRatCraftingTable && ((TileEntityRatCraftingTable)RatsMod.PROXY.getRefrencedTE()).hasMultipleRecipes();
    }
}

