/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.block;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheadsConfig;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.ToolType;

public class FertilizedFarmlandBlock
extends FarmlandBlock {
    private final List<FarmlandTrait> traits;

    public FertilizedFarmlandBlock(FarmlandTrait ... traits) {
        super(Block.Properties.func_200945_a((Material)Material.field_151578_c).func_200947_a(SoundType.field_185849_b).func_200943_b(0.6f).func_200944_c().harvestTool(ToolType.SHOVEL));
        this.traits = Lists.newArrayList((Object[])traits);
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        return true;
    }

    public boolean isFertile(BlockState state, IBlockReader world, BlockPos pos) {
        return (Integer)world.func_180495_p(pos).func_177229_b((IProperty)field_176531_a) > 0;
    }

    public float getDoubleGrowthChance() {
        return (float)this.traits.stream().mapToDouble(FarmlandTrait::getDoubleGrowthChance).sum();
    }

    public float getBonusCropChance() {
        return (float)this.traits.stream().mapToDouble(FarmlandTrait::getBonusCropChance).sum();
    }

    public float getRegressionChance() {
        return ((Double)FarmingForBlockheadsConfig.COMMON.fertilizerRegressionChance.get()).floatValue();
    }

    private boolean isStable() {
        return this.traits.stream().anyMatch(FarmlandTrait::isStable);
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        if (!this.isStable()) {
            super.func_180658_a(world, pos, entity, fallDistance);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        int moisture = (Integer)state.func_177229_b((IProperty)field_176531_a);
        if (!FertilizedFarmlandBlock.func_176530_e((IWorldReader)world, (BlockPos)pos) && !world.func_175727_C(pos.func_177984_a())) {
            if (moisture > 0) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)field_176531_a, (Comparable)Integer.valueOf(moisture - 1)), 2);
            } else if (!this.hasCropsFFB((IBlockReader)world, pos) && this.traits.stream().noneMatch(FarmlandTrait::isStable)) {
                FertilizedFarmlandBlock.func_199610_d((BlockState)state, (World)world, (BlockPos)pos);
            }
        } else if (moisture < 7) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)field_176531_a, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public Collection<FarmlandTrait> getTraits() {
        return this.traits;
    }

    private boolean hasCropsFFB(IBlockReader worldIn, BlockPos pos) {
        BlockState state = worldIn.func_180495_p(pos.func_177984_a());
        return state.func_177230_c() instanceof IPlantable && this.canSustainPlant(state, worldIn, pos, Direction.UP, (IPlantable)state.func_177230_c());
    }

    public void func_190948_a(ItemStack itemStack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        for (FarmlandTrait trait : this.traits) {
            TranslationTextComponent traitComponent = new TranslationTextComponent("tooltip.farmingforblockheads:trait_" + trait.getTraitName(), new Object[0]);
            traitComponent.func_150256_b().func_150238_a(trait.getTraitColor());
            tooltip.add((ITextComponent)traitComponent);
        }
    }

    public static class FarmlandStableTrait
    implements FarmlandTrait {
        @Override
        public boolean isStable() {
            return true;
        }

        @Override
        public String getTraitName() {
            return "stable";
        }

        @Override
        public TextFormatting getTraitColor() {
            return TextFormatting.YELLOW;
        }
    }

    public static class FarmlandRichTrait
    implements FarmlandTrait {
        @Override
        public float getBonusCropChance() {
            return ((Double)FarmingForBlockheadsConfig.COMMON.fertilizerBonusCropChance.get()).floatValue();
        }

        @Override
        public String getTraitName() {
            return "rich";
        }

        @Override
        public TextFormatting getTraitColor() {
            return TextFormatting.GREEN;
        }
    }

    public static class FarmlandHealthyTrait
    implements FarmlandTrait {
        @Override
        public float getDoubleGrowthChance() {
            return ((Double)FarmingForBlockheadsConfig.COMMON.fertilizerBonusGrowthChance.get()).floatValue();
        }

        @Override
        public String getTraitName() {
            return "healthy";
        }

        @Override
        public TextFormatting getTraitColor() {
            return TextFormatting.DARK_RED;
        }
    }

    public static interface FarmlandTrait {
        default public float getDoubleGrowthChance() {
            return 0.0f;
        }

        default public float getBonusCropChance() {
            return 0.0f;
        }

        default public boolean isStable() {
            return false;
        }

        public String getTraitName();

        public TextFormatting getTraitColor();
    }
}

