/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.ItemUtils;
import net.blay09.mods.cookingforblockheads.block.BlockDyeableKitchen;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.item.ModItems;
import net.blay09.mods.cookingforblockheads.tile.FridgeTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class FridgeBlock
extends BlockDyeableKitchen {
    public static final String name = "fridge";
    public static final ResourceLocation registryName = new ResourceLocation("cookingforblockheads", "fridge");
    public static final EnumProperty<FridgeModelType> MODEL_TYPE = EnumProperty.func_177709_a((String)"model", FridgeModelType.class);
    public static final BooleanProperty PRESERVATION_CHAMBER = BooleanProperty.func_177716_a((String)"preservation_chamber");
    public static final BooleanProperty ICE_UNIT = BooleanProperty.func_177716_a((String)"ice_unit");

    public FridgeBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200948_a(5.0f, 10.0f), registryName);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)PRESERVATION_CHAMBER, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)ICE_UNIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, MODEL_TYPE, FLIPPED, PRESERVATION_CHAMBER, ICE_UNIT, COLOR, HAS_COLOR});
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FridgeTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (this.tryRecolorBlock(state, heldItem, world, pos, player, rayTraceResult)) {
            return ActionResultType.SUCCESS;
        }
        FridgeTileEntity tileFridge = (FridgeTileEntity)world.func_175625_s(pos);
        Direction frontFace = (Direction)state.func_177229_b((IProperty)FACING);
        if (rayTraceResult.func_216354_b() == frontFace && tileFridge != null) {
            if (player.func_225608_bj_()) {
                tileFridge.getBaseFridge().getDoorAnimator().toggleForcedOpen();
                return ActionResultType.SUCCESS;
            }
            if (!heldItem.func_190926_b() && tileFridge.getBaseFridge().getDoorAnimator().isForcedOpen()) {
                heldItem = ItemHandlerHelper.insertItemStacked((IItemHandler)tileFridge.getCombinedItemHandler(), (ItemStack)heldItem, (boolean)false);
                player.func_184611_a(hand, heldItem);
                return ActionResultType.SUCCESS;
            }
        }
        if (!world.field_72995_K) {
            if (!heldItem.func_190926_b() && Block.func_149634_a((Item)heldItem.func_77973_b()) instanceof FridgeBlock && rayTraceResult.func_216354_b() != frontFace) {
                return ActionResultType.FAIL;
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tileFridge, (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        boolean below = world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof FridgeBlock;
        boolean above = world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof FridgeBlock;
        return !(below && above || below && world.func_180495_p(pos.func_177979_c(2)).func_177230_c() instanceof FridgeBlock || above && world.func_180495_p(pos.func_177981_b(2)).func_177230_c() instanceof FridgeBlock || !super.func_196260_a(state, world, pos));
    }

    @Override
    @Nonnull
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        return (BlockState)state.func_206870_a((IProperty)FLIPPED, (Comparable)Boolean.valueOf(this.shouldBePlacedFlipped(context, (Direction)state.func_177229_b((IProperty)FACING))));
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        BlockPos posBelow = currentPos.func_177977_b();
        BlockState stateBelow = world.func_180495_p(posBelow);
        BlockPos posAbove = currentPos.func_177984_a();
        BlockState stateAbove = world.func_180495_p(posAbove);
        if (stateBelow.func_177230_c() == ModBlocks.fridge && stateBelow.func_177229_b(MODEL_TYPE) == FridgeModelType.SMALL) {
            world.func_180501_a(posBelow, (BlockState)((BlockState)stateBelow.func_206870_a(MODEL_TYPE, (Comparable)((Object)FridgeModelType.LARGE_LOWER))).func_206870_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)), 3);
            return (BlockState)state.func_206870_a(MODEL_TYPE, (Comparable)((Object)FridgeModelType.LARGE_UPPER));
        }
        if (stateAbove.func_177230_c() == ModBlocks.fridge && stateAbove.func_177229_b(MODEL_TYPE) == FridgeModelType.SMALL) {
            world.func_180501_a(posAbove, (BlockState)((BlockState)stateAbove.func_206870_a(MODEL_TYPE, (Comparable)((Object)FridgeModelType.LARGE_UPPER))).func_206870_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)), 3);
            return (BlockState)state.func_206870_a(MODEL_TYPE, (Comparable)((Object)FridgeModelType.LARGE_LOWER));
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    @Override
    protected boolean isDyeable() {
        return true;
    }

    @Override
    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.func_177230_c() != state.func_177230_c()) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof FridgeTileEntity) {
                if (((FridgeTileEntity)tileEntity).hasIceUpgrade()) {
                    ItemUtils.spawnItemStack(world, (float)pos.func_177958_n() + 0.5f, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, new ItemStack((IItemProvider)ModItems.iceUnit));
                }
                if (((FridgeTileEntity)tileEntity).hasPreservationUpgrade()) {
                    ItemUtils.spawnItemStack(world, (float)pos.func_177958_n() + 0.5f, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, new ItemStack((IItemProvider)ModItems.preservationChamber));
                }
            }
            BlockPos posAbove = pos.func_177984_a();
            BlockState stateAbove = world.func_180495_p(posAbove);
            BlockPos posBelow = pos.func_177977_b();
            BlockState stateBelow = world.func_180495_p(posBelow);
            if (stateAbove.func_177230_c() == ModBlocks.fridge && stateAbove.func_177229_b(MODEL_TYPE) == FridgeModelType.LARGE_UPPER) {
                world.func_180501_a(posAbove, (BlockState)stateAbove.func_206870_a(MODEL_TYPE, (Comparable)((Object)FridgeModelType.SMALL)), 3);
            } else if (stateBelow.func_177230_c() == ModBlocks.fridge && stateBelow.func_177229_b(MODEL_TYPE) == FridgeModelType.LARGE_LOWER) {
                world.func_180501_a(posBelow, (BlockState)stateBelow.func_206870_a(MODEL_TYPE, (Comparable)((Object)FridgeModelType.SMALL)), 3);
            }
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public static enum FridgeModelType implements IStringSerializable
    {
        SMALL,
        LARGE_LOWER,
        LARGE_UPPER;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

