/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tmechworks.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.network.PacketDistributor;
import slimeknights.tmechworks.api.disguisestate.DisguiseStates;
import slimeknights.tmechworks.client.gui.components.ArrowWidget;
import slimeknights.tmechworks.client.gui.components.DisguiseStateWidget;
import slimeknights.tmechworks.common.blocks.DrawbridgeBlock;
import slimeknights.tmechworks.common.blocks.tileentity.DrawbridgeTileEntity;
import slimeknights.tmechworks.common.blocks.tileentity.RedstoneMachineTileEntity;
import slimeknights.tmechworks.common.inventory.DrawbridgeContainer;
import slimeknights.tmechworks.common.network.PacketHandler;
import slimeknights.tmechworks.common.network.packet.ServerReopenUiPacket;
import slimeknights.tmechworks.common.network.packet.UpdatePlaceDirectionPacket;
import slimeknights.tmechworks.library.Util;

public class DrawbridgeScreen
extends ContainerScreen<DrawbridgeContainer> {
    public static final ResourceLocation SCREEN_LOCATION = new ResourceLocation("tmechworks", "textures/gui/drawbridge.png");
    public static final ResourceLocation ADVANCED_LOCATION = new ResourceLocation("tmechworks", "textures/gui/drawbridge_advanced.png");
    public DisguiseStateWidget disguiseWidget;
    public final boolean isAdvanced;
    private final int slotCount;

    public DrawbridgeScreen(DrawbridgeContainer container, PlayerInventory inventory, ITextComponent name) {
        super((Container)container, inventory, name);
        this.isAdvanced = ((DrawbridgeTileEntity)container.getTileEntity()).stats.isAdvanced;
        this.slotCount = ((DrawbridgeTileEntity)container.getTileEntity()).slots.func_70302_i_();
    }

    public static DrawbridgeScreen create(DrawbridgeContainer container, PlayerInventory player, ITextComponent title) {
        return new DrawbridgeScreen(container, player, title);
    }

    protected void init() {
        super.init();
        int aX = 0;
        int aY = 0;
        if (this.isAdvanced) {
            aX = this.field_147003_i + 192;
            aY = this.field_147009_r + 10;
        } else {
            aX = (this.width - this.field_146999_f) / 2 + 110;
            aY = (this.height - this.field_147000_g) / 2 + 20;
        }
        ArrowWidget arrow = new ArrowWidget(aX, aY, this.width, this.height, true, this::arrowClicked);
        this.updateSelection(arrow);
        this.addButton(arrow);
        this.disguiseWidget = new DisguiseStateWidget(this.field_147003_i + 198, this.field_147009_r + 133, (RedstoneMachineTileEntity)((DrawbridgeContainer)this.field_147002_h).getTileEntity());
        this.addButton(this.disguiseWidget);
    }

    public void tick() {
        ItemStack disguise;
        super.tick();
        DrawbridgeTileEntity te = (DrawbridgeTileEntity)((DrawbridgeContainer)this.field_147002_h).getTileEntity();
        if (this.isAdvanced != te.stats.isAdvanced || this.slotCount != te.slots.func_70302_i_()) {
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new ServerReopenUiPacket(((DrawbridgeTileEntity)((DrawbridgeContainer)this.field_147002_h).getTileEntity()).func_174877_v()));
        }
        if ((disguise = te.getDisguiseBlock()).func_77973_b() instanceof BlockItem) {
            BlockState disguiseState = ((BlockItem)disguise.func_77973_b()).func_179223_d().func_176223_P();
            this.disguiseWidget.setState(DisguiseStates.getForState(disguiseState), te.getDisguiseState());
        } else {
            this.disguiseWidget.setState(null, null);
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(SCREEN_LOCATION);
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.blit(this.field_147003_i - 44, this.field_147009_r + this.field_147000_g - 65, 0, 182, 47, 60);
        this.blit(this.field_147003_i + this.field_146999_f - 3, this.field_147009_r + this.field_147000_g - 37, 52, 182, 29, 32);
        if (this.disguiseWidget.getColumnCount() > 0) {
            DrawbridgeScreen.blit(this.field_147003_i + this.field_146999_f + 22, this.field_147009_r + this.field_147000_g - 37, this.disguiseWidget.getColumnCount() * 8 + 2, 32, 75, 76, 182, 214);
            DrawbridgeScreen.blit(this.field_147003_i + this.field_146999_f + 22 + this.disguiseWidget.getColumnCount() * 8 + 2, this.field_147009_r + this.field_147000_g - 37, 3, 32, 78, 81, 183, 214);
        }
        if (!this.isAdvanced) {
            this.drawSlicedBox(this.field_147003_i + 75, this.field_147009_r + 31, 26, 26, 17, 166);
        } else {
            this.minecraft.func_110434_K().func_110577_a(ADVANCED_LOCATION);
            this.blit(this.field_147003_i - 18, this.field_147009_r - 80, 0, 0, 213, 148);
            this.blit(this.field_147003_i + 191, this.field_147009_r + 4, 0, 196, 63, 60);
            this.drawAdvancedSlots();
        }
    }

    private void drawAdvancedSlots() {
        for (Slot s : ((DrawbridgeContainer)this.field_147002_h).mainSlots) {
            this.blit(this.field_147003_i + s.field_75223_e - 1, this.field_147009_r + s.field_75221_f - 1, 0, 166, 18, 18);
        }
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        if (this.field_147006_u == null) {
            return;
        }
        if (!this.isAdvanced || this.field_147006_u.func_75216_d()) {
            super.func_191948_b(mouseX, mouseY);
        } else if (this.field_147006_u.field_75224_c == ((DrawbridgeTileEntity)((DrawbridgeContainer)this.func_212873_a_()).getTileEntity()).slots) {
            this.renderTooltip(TextFormatting.GRAY + I18n.func_135052_a((String)Util.prefix("gui.blocknum"), (Object[])new Object[]{this.field_147006_u.getSlotIndex() + 1}), mouseX, mouseY);
        }
    }

    public List<String> getTooltipFromItem(ItemStack stack) {
        List list = super.getTooltipFromItem(stack);
        if (this.isAdvanced && this.field_147006_u.field_75224_c == ((DrawbridgeTileEntity)((DrawbridgeContainer)this.func_212873_a_()).getTileEntity()).slots) {
            list.add("");
            list.add(TextFormatting.GRAY + I18n.func_135052_a((String)Util.prefix("gui.blocknum"), (Object[])new Object[]{this.field_147006_u.getSlotIndex() + 1}));
        }
        if (DrawbridgeBlock.BLACKLIST.func_199685_a_(Block.func_149634_a((Item)stack.func_77973_b()))) {
            list.add("");
            list.add(I18n.func_135052_a((String)Util.prefix("gui.blacklisted"), (Object[])new Object[0]));
        }
        return list;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        int screenTop = this.isAdvanced ? -80 : 0;
        String s = this.title.func_150254_d();
        this.font.func_211126_b(s, (float)this.field_146999_f / 2.0f - (float)this.font.func_78256_a(s) / 2.0f, (float)(screenTop + 6), 0x404040);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        float scale = 0.75f;
        float invScale = 1.0f / scale;
        RenderSystem.scalef((float)scale, (float)scale, (float)scale);
        String upgrades = I18n.func_135052_a((String)Util.prefix("gui.upgrades"), (Object[])new Object[0]);
        this.font.func_211126_b(upgrades, 23.5f - (float)this.font.func_78256_a(upgrades) / 2.0f - 50.0f, (float)(this.field_146999_f - 69) * invScale, 0x404040);
        RenderSystem.scalef((float)invScale, (float)invScale, (float)invScale);
    }

    private void arrowClicked(ArrowWidget widget, ArrowWidget.Arrow arrow) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new UpdatePlaceDirectionPacket(((DrawbridgeTileEntity)((DrawbridgeContainer)this.field_147002_h).getTileEntity()).func_174877_v(), arrow.ordinal()));
        ((DrawbridgeTileEntity)((DrawbridgeContainer)this.field_147002_h).getTileEntity()).setPlaceDirection(arrow.ordinal());
        this.updateSelection(widget);
    }

    private void updateSelection(ArrowWidget arrow) {
        for (ArrowWidget.Arrow a : ArrowWidget.Arrow.values()) {
            if (arrow.getState(a) != ArrowWidget.ArrowState.SELECTED) continue;
            arrow.setState(a, ArrowWidget.ArrowState.ENABLED);
        }
        arrow.setState(ArrowWidget.Arrow.values()[((DrawbridgeTileEntity)((DrawbridgeContainer)this.field_147002_h).getTileEntity()).getRawPlaceDirection().ordinal()], ArrowWidget.ArrowState.SELECTED);
        arrow.setState(ArrowWidget.Arrow.values()[Direction.values().length + ((DrawbridgeTileEntity)((DrawbridgeContainer)this.field_147002_h).getTileEntity()).getPlaceAngle().ordinal()], ArrowWidget.ArrowState.SELECTED);
    }

    private void drawSlicedBox(int x, int y, int width, int height, int u, int v) {
        this.blit(x, y, u, v, 4, 4);
        this.blit(x + width - 4, y, u + 12, v, 4, 4);
        this.blit(x, y + height - 4, u, v + 12, 4, 4);
        this.blit(x + width - 4, y + height - 4, u + 12, v + 12, 4, 4);
        DrawbridgeScreen.blit(x + 4, y, width - 8, 4, u + 6, u + 10, v, v + 4);
        DrawbridgeScreen.blit(x + 4, y + height - 4, width - 8, 4, u + 6, u + 10, v + 12, v + 16);
        DrawbridgeScreen.blit(x, y + 4, 4, height - 8, u, u + 4, v + 6, v + 10);
        DrawbridgeScreen.blit(x + width - 4, y + 4, 4, height - 8, u + 12, u + 16, v + 6, v + 10);
        DrawbridgeScreen.blit(x + 4, y + 4, width - 8, height - 8, u + 6, u + 10, v + 6, v + 10);
    }

    public static void blit(int x, int y, int w, int h, int minU, int maxU, int minV, int maxV) {
        DrawbridgeScreen.blit(x, y, w, h, minU, maxU, minV, maxV, 256.0f, 256.0f);
    }

    public static void blit(int x, int y, int w, int h, int minU, int maxU, int minV, int maxV, float tw, float th) {
        DrawbridgeScreen.innerBlit((int)x, (int)(x + w), (int)y, (int)(y + h), (int)0, (float)((float)minU / tw), (float)((float)maxU / tw), (float)((float)minV / th), (float)((float)maxV / th));
    }
}

