/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.item;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.NBTConverter;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.actions.items.ActionSetFood;
import com.blamejared.crafttweaker.impl.data.MapData;
import com.blamejared.crafttweaker.impl.food.MCFood;
import com.blamejared.crafttweaker.impl.ingredients.IngredientNBT;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class MCItemStack
implements IItemStack {
    private final ItemStack internal;
    public static Supplier<MCItemStack> EMPTY = () -> new MCItemStack(ItemStack.field_190927_a);

    public MCItemStack(ItemStack internal) {
        this.internal = internal.func_77946_l();
    }

    @Override
    public IItemStack copy() {
        return new MCItemStack(this.internal.func_77946_l());
    }

    @Override
    public IItemStack setDisplayName(String name) {
        ItemStack newStack = this.internal.func_77946_l();
        newStack.func_200302_a((ITextComponent)new StringTextComponent(name));
        return new MCItemStack(newStack);
    }

    @Override
    public IItemStack setAmount(int amount) {
        ItemStack newStack = this.internal.func_77946_l();
        newStack.func_190920_e(amount);
        return new MCItemStack(newStack);
    }

    @Override
    public IItemStack withDamage(int damage) {
        ItemStack copy = this.internal.func_77946_l();
        copy.func_196085_b(damage);
        return new MCItemStack(copy);
    }

    @Override
    public IItemStack withTag(IData tag) {
        ItemStack copy = this.internal.func_77946_l();
        if (!(tag instanceof MapData)) {
            tag = new MapData(tag.asMap());
        }
        copy.func_77982_d(((MapData)tag).getInternal());
        return new MCItemStack(copy);
    }

    @Override
    public MCFood getFood() {
        return new MCFood(this.getInternal().func_77973_b().func_219967_s());
    }

    @Override
    public void setFood(MCFood food) {
        CraftTweakerAPI.apply(new ActionSetFood(this, food));
    }

    @Override
    public String getCommandString() {
        StringBuilder sb = new StringBuilder("<item:");
        sb.append(this.internal.func_77973_b().getRegistryName());
        sb.append(">");
        if (this.internal.func_77978_p() != null) {
            sb.append(".withTag(");
            sb.append(NBTConverter.convert((INBT)this.internal.func_77978_p()).asString());
            sb.append(")");
        }
        if (this.internal.func_77952_i() > 0) {
            sb.append(".withDamage(").append(this.internal.func_77952_i()).append(")");
        }
        if (this.getAmount() != 1) {
            sb.append(" * ").append(this.getAmount());
        }
        return sb.toString();
    }

    @Override
    public ItemStack getInternal() {
        return this.internal;
    }

    @Override
    public Ingredient asVanillaIngredient() {
        return new IngredientNBT(this.getInternal());
    }

    public String toString() {
        return this.getCommandString();
    }

    @Override
    public IItemStack[] getItems() {
        return new IItemStack[]{this};
    }
}

