/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import javax.annotation.Nonnull;
import mekanism.api.IConfigCardAccess;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ITileComponent;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.EnergyCubeEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.resolver.basic.BasicCapabilityResolver;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.tier.EnergyCubeTier;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.EnergySlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.upgrade.EnergyCubeUpgradeData;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.CableUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;

public class TileEntityEnergyCube
extends TileEntityMekanism
implements ISideConfiguration,
IConfigCardAccess {
    private EnergyCubeTier tier;
    private float prevScale;
    public TileComponentEjector ejectorComponent;
    public TileComponentConfig configComponent = new TileComponentConfig(this, TransmissionType.ENERGY, TransmissionType.ITEM);
    private EnergyCubeEnergyContainer energyContainer;
    private EnergyInventorySlot chargeSlot;
    private EnergyInventorySlot dischargeSlot;

    public TileEntityEnergyCube(IBlockProvider blockProvider) {
        super(blockProvider);
        ConfigInfo energyConfig;
        ConfigInfo itemConfig = this.configComponent.getConfig(TransmissionType.ITEM);
        if (itemConfig != null) {
            itemConfig.addSlotInfo(DataType.INPUT, new InventorySlotInfo(true, true, this.chargeSlot));
            itemConfig.addSlotInfo(DataType.OUTPUT, new InventorySlotInfo(true, true, this.dischargeSlot));
            itemConfig.setDataType(RelativeSide.LEFT, DataType.INPUT);
            itemConfig.setDataType(RelativeSide.RIGHT, DataType.OUTPUT);
            itemConfig.setCanEject(false);
        }
        if ((energyConfig = this.configComponent.getConfig(TransmissionType.ENERGY)) != null) {
            energyConfig.addSlotInfo(DataType.INPUT, new EnergySlotInfo(true, false, this.energyContainer));
            energyConfig.addSlotInfo(DataType.OUTPUT, new EnergySlotInfo(false, true, this.energyContainer));
            energyConfig.fill(DataType.INPUT);
            energyConfig.setDataType(RelativeSide.FRONT, DataType.OUTPUT);
            energyConfig.setEjecting(true);
        }
        this.ejectorComponent = new TileComponentEjector(this);
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIG_CARD_CAPABILITY, this));
    }

    @Override
    protected void presetVariables() {
        this.tier = Attribute.getTier(this.getBlockType(), EnergyCubeTier.class);
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.energyContainer = EnergyCubeEnergyContainer.create(this.tier, (IMekanismStrictEnergyHandler)this);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.dischargeSlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityEnergyCube)this).func_145831_w(), this, 17, 35);
        builder.addSlot(this.dischargeSlot);
        this.chargeSlot = EnergyInventorySlot.drain(this.energyContainer, this, 143, 35);
        builder.addSlot(this.chargeSlot);
        this.dischargeSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.chargeSlot.setSlotOverlay(SlotOverlay.PLUS);
        return builder.build();
    }

    public EnergyCubeTier getTier() {
        return this.tier;
    }

    @Override
    protected void onUpdateServer() {
        float newScale;
        ConfigInfo info;
        super.onUpdateServer();
        this.chargeSlot.drainContainer();
        this.dischargeSlot.fillContainerOrConvert();
        if (!this.energyContainer.isEmpty() && MekanismUtils.canFunction(this) && (info = this.configComponent.getConfig(TransmissionType.ENERGY)) != null && info.isEjecting()) {
            CableUtils.emit(info.getSidesForData(DataType.OUTPUT), this.energyContainer, this, this.tier.getOutput());
        }
        if ((newScale = MekanismUtils.getScale(this.prevScale, this.energyContainer)) != this.prevScale) {
            this.prevScale = newScale;
            this.sendUpdatePacket();
        }
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.energyContainer.getEnergy(), this.energyContainer.getMaxEnergy());
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public Direction getOrientation() {
        return this.getDirection();
    }

    @Override
    public void parseUpgradeData(@Nonnull IUpgradeData upgradeData) {
        if (upgradeData instanceof EnergyCubeUpgradeData) {
            EnergyCubeUpgradeData data = (EnergyCubeUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.getEnergyContainer().setEnergy(data.energyContainer.getEnergy());
            this.chargeSlot.setStack(data.chargeSlot.getStack());
            this.dischargeSlot.setStack(data.dischargeSlot.getStack());
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components);
            }
        } else {
            super.parseUpgradeData(upgradeData);
        }
    }

    public EnergyCubeEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }

    @Override
    @Nonnull
    public EnergyCubeUpgradeData getUpgradeData() {
        return new EnergyCubeUpgradeData(this.redstone, this.getControlType(), this.getEnergyContainer(), this.chargeSlot, this.dischargeSlot, this.getComponents());
    }

    public float getEnergyScale() {
        return this.prevScale;
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        updateTag.func_74776_a("scale", this.prevScale);
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundNBT tag) {
        super.handleUpdateTag(tag);
        NBTUtils.setFloatIfPresent(tag, "scale", scale -> {
            this.prevScale = scale;
        });
    }
}

