/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.entity.EntityRobit;
import mekanism.common.item.IItemSustainedInventory;
import mekanism.common.item.ItemEnergized;
import mekanism.common.tile.TileEntityChargepad;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.TextComponentUtil;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemRobit
extends ItemEnergized
implements IItemSustainedInventory {
    public ItemRobit(Item.Properties properties) {
        super(() -> EntityRobit.MAX_ENERGY.multiply(0.005), () -> EntityRobit.MAX_ENERGY, properties);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.add(MekanismLang.ROBIT_NAME.translateColored(EnumColor.INDIGO, new Object[]{EnumColor.GRAY, this.getName(stack)}));
        tooltip.add(MekanismLang.HAS_INVENTORY.translateColored(EnumColor.AQUA, new Object[]{EnumColor.GRAY, BooleanStateDisplay.YesNo.of(this.hasInventory(new Object[]{stack}))}));
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos;
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        World world = context.func_195991_k();
        TileEntityMekanism chargepad = MekanismUtils.getTileEntity(TileEntityChargepad.class, (IBlockReader)world, pos = context.func_195995_a());
        if (chargepad != null && !chargepad.getActive()) {
            Hand hand = context.func_221531_n();
            ItemStack stack = player.func_184586_b(hand);
            if (!world.field_72995_K) {
                EntityRobit robit = new EntityRobit(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5);
                robit.setHome(Coord4D.get(chargepad));
                IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
                if (energyContainer != null) {
                    robit.getEnergyContainer().setEnergy(energyContainer.getEnergy());
                }
                robit.setOwnerUUID(player.func_110124_au());
                robit.setInventory(this.getInventory(new Object[]{stack}), new Object[0]);
                robit.func_200203_b(this.getName(stack));
                world.func_217376_c((Entity)robit);
            }
            player.func_184611_a(hand, ItemStack.field_190927_a);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void setName(ItemStack stack, String name) {
        ItemDataUtils.setString(stack, "name", name);
    }

    public ITextComponent getName(ItemStack stack) {
        String name = ItemDataUtils.getString(stack, "name");
        return name.isEmpty() ? MekanismLang.ROBIT.translate(new Object[0]) : TextComponentUtil.getString(name);
    }
}

