/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.slot.BasicInventorySlot;
import net.minecraft.item.ItemStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class InputInventorySlot
extends BasicInventorySlot {
    public static InputInventorySlot at(@Nullable IMekanismInventory inventory, int x, int y) {
        return InputInventorySlot.at(alwaysTrue, inventory, x, y);
    }

    public static InputInventorySlot at(Predicate<@NonNull ItemStack> isItemValid, @Nullable IMekanismInventory inventory, int x, int y) {
        return InputInventorySlot.at(alwaysTrue, isItemValid, inventory, x, y);
    }

    public static InputInventorySlot at(Predicate<@NonNull ItemStack> insertPredicate, Predicate<@NonNull ItemStack> isItemValid, @Nullable IMekanismInventory inventory, int x, int y) {
        Objects.requireNonNull(insertPredicate, "Insertion check cannot be null");
        Objects.requireNonNull(isItemValid, "Item validity check cannot be null");
        return new InputInventorySlot(insertPredicate, isItemValid, inventory, x, y);
    }

    protected InputInventorySlot(Predicate<@NonNull ItemStack> insertPredicate, Predicate<@NonNull ItemStack> isItemValid, @Nullable IMekanismInventory inventory, int x, int y) {
        super(notExternal, (ItemStack stack, AutomationType automationType) -> insertPredicate.test((ItemStack)stack), isItemValid, inventory, x, y);
        this.setSlotType(ContainerSlotType.INPUT);
    }
}

