/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte;

import java.util.function.Function;
import javax.annotation.Nonnull;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.GasTags;
import moze_intel.projecte.api.nss.AbstractNSSTag;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.util.ResourceLocation;

public final class NSSGas
extends AbstractNSSTag<Gas> {
    private NSSGas(@Nonnull ResourceLocation resourceLocation, boolean isTag) {
        super(resourceLocation, isTag);
    }

    @Nonnull
    public static NSSGas createGas(@Nonnull GasStack stack) {
        return NSSGas.createGas((Gas)stack.getType());
    }

    @Nonnull
    public static NSSGas createGas(@Nonnull Gas gas) {
        if (gas.isEmptyType()) {
            throw new IllegalArgumentException("Can't make NSSGas with an empty gas");
        }
        return NSSGas.createGas(gas.getRegistryName());
    }

    @Nonnull
    public static NSSGas createGas(@Nonnull ResourceLocation gasID) {
        return new NSSGas(gasID, false);
    }

    @Nonnull
    public static NSSGas createTag(@Nonnull ResourceLocation tagId) {
        return new NSSGas(tagId, true);
    }

    @Nonnull
    public static NSSGas createTag(@Nonnull Tag<Gas> tag) {
        return NSSGas.createTag(tag.func_199886_b());
    }

    protected boolean isInstance(AbstractNSSTag o) {
        return o instanceof NSSGas;
    }

    @Nonnull
    public String getJsonPrefix() {
        return "GAS|";
    }

    @Nonnull
    public String getType() {
        return "Gas";
    }

    @Nonnull
    protected TagCollection<Gas> getTagCollection() {
        return GasTags.getCollection();
    }

    protected Function<Gas, NormalizedSimpleStack> createNew() {
        return NSSGas::createGas;
    }
}

