/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.common.base.ILogisticalTransporter;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.transporter.PathfinderCache;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.transmitters.grid.InventoryNetwork;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.apache.commons.lang3.tuple.Pair;

public final class TransporterPathfinder {
    private static List<Destination> getPaths(ILogisticalTransporter start, TransporterStack stack, TransitRequest request, int min) {
        InventoryNetwork network = (InventoryNetwork)start.getTransmitterNetwork();
        if (network == null) {
            return Collections.emptyList();
        }
        Long2ObjectOpenHashMap chunkMap = new Long2ObjectOpenHashMap();
        List<InventoryNetwork.AcceptorData> acceptors = network.calculateAcceptors(request, stack, (Long2ObjectMap<IChunk>)chunkMap);
        ArrayList<Destination> paths = new ArrayList<Destination>();
        for (InventoryNetwork.AcceptorData data : acceptors) {
            Destination path = TransporterPathfinder.getPath(data, start, stack, min, (Long2ObjectMap<IChunk>)chunkMap);
            if (path == null) continue;
            paths.add(path);
        }
        Collections.sort(paths);
        return paths;
    }

    private static boolean checkPath(World world, List<Coord4D> path, TransporterStack stack, Long2ObjectMap<IChunk> chunkMap) {
        for (int i = path.size() - 1; i > 0; --i) {
            TileEntity tile = MekanismUtils.getTileEntity((IWorld)world, chunkMap, path.get(i));
            Optional<ILogisticalTransporter> capability = MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, null));
            if (capability.isPresent()) {
                ILogisticalTransporter transporter = capability.get();
                if (transporter.getColor() == null || transporter.getColor() == stack.color) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static Destination getPath(InventoryNetwork.AcceptorData data, ILogisticalTransporter start, TransporterStack stack, int min, Long2ObjectMap<IChunk> chunkMap) {
        final TransitRequest.TransitResponse response = data.getResponse();
        if (response.getSendingAmount() >= min) {
            Coord4D dest = data.getLocation();
            PathfinderCache.CachedPath test = PathfinderCache.getCache(start, dest, data.getSides());
            if (test != null && TransporterPathfinder.checkPath(start.world(), test.getPath(), stack, chunkMap)) {
                return new Destination(test.getPath(), false, response, test.getCost());
            }
            Pathfinder p = new Pathfinder(new Pathfinder.DestChecker(){

                @Override
                public boolean isValid(TransporterStack stack, Direction dir, TileEntity tile) {
                    return InventoryUtils.canInsert(tile, stack.color, response.getStack(), dir, false);
                }
            }, start.world(), dest, start.coord(), stack, chunkMap);
            List<Coord4D> path = p.getPath();
            if (path.size() >= 2) {
                PathfinderCache.addCachedPath(start, new PathfinderCache.PathData(start.coord(), dest, p.getSide()), path, p.finalScore);
                return new Destination(path, false, response, p.finalScore);
            }
        }
        return null;
    }

    @Nullable
    public static Destination getNewBasePath(ILogisticalTransporter start, TransporterStack stack, TransitRequest request, int min) {
        List<Destination> paths = TransporterPathfinder.getPaths(start, stack, request, min);
        if (paths.isEmpty()) {
            return null;
        }
        return paths.get(0);
    }

    public static Destination getNewRRPath(ILogisticalTransporter start, TransporterStack stack, TransitRequest request, TileEntityLogisticalSorter outputter, int min) {
        List<Destination> paths = TransporterPathfinder.getPaths(start, stack, request, min);
        Object2ObjectOpenHashMap destPaths = new Object2ObjectOpenHashMap();
        for (Destination d : paths) {
            Coord4D dest = d.getPath().get(0);
            Destination destination = (Destination)destPaths.get(dest);
            if (destination != null && destination.getPath().size() >= d.getPath().size()) continue;
            destPaths.put(dest, d);
        }
        ArrayList dests = new ArrayList(destPaths.values());
        Collections.sort(dests);
        Destination closest = null;
        if (!dests.isEmpty()) {
            if (outputter.rrIndex <= dests.size() - 1) {
                closest = (Destination)dests.get(outputter.rrIndex);
                if (outputter.rrIndex == dests.size() - 1) {
                    outputter.rrIndex = 0;
                } else if (outputter.rrIndex < dests.size() - 1) {
                    ++outputter.rrIndex;
                }
            } else {
                closest = (Destination)dests.get(dests.size() - 1);
                outputter.rrIndex = 0;
            }
        }
        return closest;
    }

    public static Pair<List<Coord4D>, TransporterStack.Path> getIdlePath(ILogisticalTransporter start, TransporterStack stack) {
        IdlePath d;
        Destination dest;
        Long2ObjectOpenHashMap chunkMap = new Long2ObjectOpenHashMap();
        if (stack.homeLocation != null) {
            Pathfinder p = new Pathfinder(new Pathfinder.DestChecker(){

                @Override
                public boolean isValid(TransporterStack stack, Direction side, TileEntity tile) {
                    return InventoryUtils.canInsert(tile, stack.color, stack.itemStack, side, true);
                }
            }, start.world(), stack.homeLocation, start.coord(), stack, (Long2ObjectMap<IChunk>)chunkMap);
            List<Coord4D> path = p.getPath();
            if (path.size() >= 2) {
                return Pair.of(path, (Object)((Object)TransporterStack.Path.HOME));
            }
            stack.homeLocation = null;
        }
        if ((dest = (d = new IdlePath(start.world(), start.coord(), stack)).find((Long2ObjectMap<IChunk>)chunkMap)) == null) {
            return null;
        }
        return Pair.of(dest.getPath(), (Object)((Object)dest.getPathType()));
    }

    public static class Pathfinder {
        private final Set<Coord4D> openSet;
        private final Set<Coord4D> closedSet;
        private final Map<Coord4D, Coord4D> navMap;
        private final Object2DoubleOpenHashMap<Coord4D> gScore;
        private final Object2DoubleOpenHashMap<Coord4D> fScore;
        private final Coord4D start;
        private final Coord4D finalNode;
        private final TransporterStack transportStack;
        private final DestChecker destChecker;
        private double finalScore;
        private Direction side;
        private List<Coord4D> results;
        private World world;

        public Pathfinder(DestChecker checker, World world, Coord4D finishObj, Coord4D startObj, TransporterStack stack, Long2ObjectMap<IChunk> chunkMap) {
            this.destChecker = checker;
            this.world = world;
            this.finalNode = finishObj;
            this.start = startObj;
            this.transportStack = stack;
            this.openSet = new ObjectOpenHashSet();
            this.closedSet = new ObjectOpenHashSet();
            this.navMap = new Object2ObjectOpenHashMap();
            this.gScore = new Object2DoubleOpenHashMap();
            this.fScore = new Object2DoubleOpenHashMap();
            this.results = new ArrayList<Coord4D>();
            this.find(chunkMap, this.start);
        }

        public boolean find(Long2ObjectMap<IChunk> chunkMap, Coord4D start) {
            this.openSet.add(start);
            this.gScore.put((Object)start, 0.0);
            this.fScore.put((Object)start, start.distanceTo(this.finalNode));
            boolean hasValidDirection = false;
            TileEntity startTile = MekanismUtils.getTileEntity((IWorld)this.world, chunkMap, start);
            for (Direction direction : EnumUtils.DIRECTIONS) {
                Coord4D neighbor = start.offset(direction);
                TileEntity neighborTile = MekanismUtils.getTileEntity((IWorld)this.world, chunkMap, neighbor);
                if (this.transportStack.canInsertToTransporter(neighborTile, direction, startTile)) {
                    hasValidDirection = true;
                    break;
                }
                if (!this.isValidDestination(start, startTile, direction, neighbor, neighborTile)) continue;
                return true;
            }
            if (!hasValidDirection) {
                return false;
            }
            double maxSearchDistance = 2.0 * start.distanceTo(this.finalNode);
            while (!this.openSet.isEmpty()) {
                Coord4D currentNode = null;
                double lowestFScore = 0.0;
                for (Coord4D node : this.openSet) {
                    if (currentNode != null && !(this.fScore.getDouble((Object)node) < lowestFScore)) continue;
                    currentNode = node;
                    lowestFScore = this.fScore.getDouble((Object)node);
                }
                if (currentNode == null) break;
                this.openSet.remove(currentNode);
                this.closedSet.add(currentNode);
                if (start.distanceTo(currentNode) > maxSearchDistance) continue;
                TileEntity currentNodeTile = MekanismUtils.getTileEntity((IWorld)this.world, chunkMap, currentNode);
                double currentScore = this.gScore.getDouble((Object)currentNode);
                for (Direction direction : EnumUtils.DIRECTIONS) {
                    Coord4D neighbor = currentNode.offset(direction);
                    TileEntity neighborEntity = MekanismUtils.getTileEntity((IWorld)this.world, chunkMap, neighbor);
                    if (this.transportStack.canInsertToTransporter(neighborEntity, direction, currentNodeTile)) {
                        double tentativeG = currentScore;
                        Optional<ILogisticalTransporter> capability = MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)neighborEntity, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, direction.func_176734_d()));
                        if (capability.isPresent()) {
                            tentativeG += capability.get().getCost();
                        }
                        if (this.closedSet.contains(neighbor) && tentativeG >= this.gScore.getDouble((Object)neighbor) || this.openSet.contains(neighbor) && !(tentativeG < this.gScore.getDouble((Object)neighbor))) continue;
                        this.navMap.put(neighbor, currentNode);
                        this.gScore.put((Object)neighbor, tentativeG);
                        this.fScore.put((Object)neighbor, tentativeG + neighbor.distanceTo(this.finalNode));
                        this.openSet.add(neighbor);
                        continue;
                    }
                    if (!this.isValidDestination(currentNode, currentNodeTile, direction, neighbor, neighborEntity)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isValidDestination(Coord4D start, TileEntity startTile, Direction direction, Coord4D neighbor, TileEntity neighborTile) {
            ILogisticalTransporter transporter;
            Optional<ILogisticalTransporter> startTransporter;
            if (neighbor.equals(this.finalNode) && this.destChecker.isValid(this.transportStack, direction, neighborTile) && (startTransporter = MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)startTile, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, null))).isPresent() && ((transporter = startTransporter.get()).canEmitTo(neighborTile, direction) || this.finalNode.equals(this.transportStack.homeLocation) && transporter.canConnect(direction))) {
                this.side = direction;
                this.results = this.reconstructPath(this.navMap, start);
                return true;
            }
            return false;
        }

        private List<Coord4D> reconstructPath(Map<Coord4D, Coord4D> naviMap, Coord4D currentNode) {
            ArrayList<Coord4D> path = new ArrayList<Coord4D>();
            path.add(currentNode);
            if (naviMap.containsKey(currentNode)) {
                path.addAll(this.reconstructPath(naviMap, naviMap.get(currentNode)));
            }
            this.finalScore = this.gScore.getDouble((Object)currentNode) + currentNode.distanceTo(this.finalNode);
            return path;
        }

        public List<Coord4D> getPath() {
            ArrayList<Coord4D> path = new ArrayList<Coord4D>();
            path.add(this.finalNode);
            path.addAll(this.results);
            return path;
        }

        public Direction getSide() {
            return this.side;
        }

        public static class DestChecker {
            public boolean isValid(TransporterStack stack, Direction side, TileEntity tile) {
                return false;
            }
        }
    }

    public static class Destination
    implements Comparable<Destination> {
        private final List<Coord4D> path;
        private TransporterStack.Path pathType;
        private final TransitRequest.TransitResponse response;
        private double score;

        public Destination(List<Coord4D> list, boolean inv, TransitRequest.TransitResponse ret, double gScore) {
            this.path = new ArrayList<Coord4D>(list);
            if (inv) {
                Collections.reverse(this.path);
            }
            this.response = ret;
            this.score = gScore;
        }

        public Destination setPathType(TransporterStack.Path type) {
            this.pathType = type;
            return this;
        }

        public Destination calculateScore(World world, Long2ObjectMap<IChunk> chunkMap) {
            this.score = 0.0;
            for (Coord4D location : this.path) {
                CapabilityUtils.getCapability((ICapabilityProvider)MekanismUtils.getTileEntity((IWorld)world, chunkMap, location.getPos()), Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, null).ifPresent(transporter -> this.score += transporter.getCost());
            }
            return this;
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.path.hashCode();
            return code;
        }

        public boolean equals(Object dest) {
            return dest instanceof Destination && ((Destination)dest).path.equals(this.path);
        }

        @Override
        public int compareTo(@Nonnull Destination dest) {
            if (this.score < dest.score) {
                return -1;
            }
            if (this.score > dest.score) {
                return 1;
            }
            return this.path.size() - dest.path.size();
        }

        public TransitRequest.TransitResponse getResponse() {
            return this.response;
        }

        public TransporterStack.Path getPathType() {
            return this.pathType;
        }

        public List<Coord4D> getPath() {
            return this.path;
        }
    }

    public static class IdlePath {
        private final World world;
        private final Coord4D start;
        private final TransporterStack transportStack;

        public IdlePath(World world, Coord4D obj, TransporterStack stack) {
            this.world = world;
            this.start = obj;
            this.transportStack = stack;
        }

        public Destination find(Long2ObjectMap<IChunk> chunkMap) {
            Destination newPath;
            ArrayList<Coord4D> ret = new ArrayList<Coord4D>();
            ret.add(this.start);
            TileEntity startTile = MekanismUtils.getTileEntity((IWorld)this.world, chunkMap, this.start);
            if (this.transportStack.idleDir == null) {
                Direction newSide = this.findSide(chunkMap);
                if (newSide == null) {
                    return null;
                }
                this.transportStack.idleDir = newSide;
                this.loopSide(chunkMap, ret, newSide, startTile);
                return new Destination(ret, true, null, 0.0).setPathType(TransporterStack.Path.NONE);
            }
            TileEntity tile = MekanismUtils.getTileEntity((IWorld)this.world, chunkMap, this.start.offset(this.transportStack.idleDir));
            if (this.transportStack.canInsertToTransporter(tile, this.transportStack.idleDir, startTile)) {
                this.loopSide(chunkMap, ret, this.transportStack.idleDir, startTile);
                return new Destination(ret, true, null, 0.0).setPathType(TransporterStack.Path.NONE);
            }
            TransitRequest request = TransitRequest.getFromTransport(this.transportStack);
            Optional<ILogisticalTransporter> capability = MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)startTile, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, null));
            if (capability.isPresent() && (newPath = TransporterPathfinder.getNewBasePath(capability.get(), this.transportStack, request, 0)) != null && newPath.getResponse() != null) {
                this.transportStack.idleDir = null;
                newPath.setPathType(TransporterStack.Path.DEST);
                return newPath;
            }
            Direction newSide = this.findSide(chunkMap);
            if (newSide == null) {
                return null;
            }
            this.transportStack.idleDir = newSide;
            this.loopSide(chunkMap, ret, newSide, startTile);
            return new Destination(ret, true, null, 0.0).setPathType(TransporterStack.Path.NONE);
        }

        private void loopSide(Long2ObjectMap<IChunk> chunkMap, List<Coord4D> list, Direction side, TileEntity startTile) {
            TileEntity lastTile = startTile;
            Coord4D coord = this.start.offset(side);
            TileEntity tile = MekanismUtils.getTileEntity((IWorld)this.world, chunkMap, coord);
            while (this.transportStack.canInsertToTransporter(tile, side, lastTile)) {
                lastTile = tile;
                list.add(coord);
                coord = coord.offset(side);
                tile = MekanismUtils.getTileEntity((IWorld)this.world, chunkMap, coord);
            }
        }

        private Direction findSide(Long2ObjectMap<IChunk> chunkMap) {
            BlockPos startPos = this.start.getPos();
            TileEntity startTile = MekanismUtils.getTileEntity((IWorld)this.world, chunkMap, startPos);
            if (this.transportStack.idleDir == null) {
                for (Direction side : EnumUtils.DIRECTIONS) {
                    TileEntity tile = MekanismUtils.getTileEntity((IWorld)this.world, chunkMap, startPos.func_177972_a(side));
                    if (!this.transportStack.canInsertToTransporter(tile, side, startTile)) continue;
                    return side;
                }
            } else {
                Direction opposite = this.transportStack.idleDir.func_176734_d();
                for (Direction side : EnumSet.complementOf(EnumSet.of(opposite))) {
                    TileEntity tile = MekanismUtils.getTileEntity((IWorld)this.world, chunkMap, startPos.func_177972_a(side));
                    if (!this.transportStack.canInsertToTransporter(tile, side, startTile)) continue;
                    return side;
                }
                TileEntity tile = MekanismUtils.getTileEntity((IWorld)this.world, chunkMap, startPos.func_177972_a(opposite));
                if (this.transportStack.canInsertToTransporter(tile, opposite, startTile)) {
                    return opposite;
                }
            }
            return null;
        }
    }
}

