/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.filter;

import javax.annotation.Nullable;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.miner.MItemStackFilter;
import mekanism.common.content.miner.MMaterialFilter;
import mekanism.common.content.miner.MModIDFilter;
import mekanism.common.content.miner.MTagFilter;
import mekanism.common.content.transporter.TItemStackFilter;
import mekanism.common.content.transporter.TMaterialFilter;
import mekanism.common.content.transporter.TModIDFilter;
import mekanism.common.content.transporter.TTagFilter;
import mekanism.common.tile.TileEntityOredictionificator;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public abstract class BaseFilter<FILTER extends BaseFilter<FILTER>>
implements IFilter<FILTER> {
    @Override
    public abstract FILTER clone();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    @Override
    public CompoundNBT write(CompoundNBT nbtTags) {
        nbtTags.func_74768_a("type", this.getFilterType().ordinal());
        return nbtTags;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.getFilterType());
    }

    @Nullable
    public static IFilter<?> readFromNBT(CompoundNBT nbt) {
        if (nbt.func_150297_b("type", 3)) {
            IFilter<?> filter = BaseFilter.fromType(FilterType.byIndexStatic(nbt.func_74762_e("type")));
            if (filter != null) {
                filter.read(nbt);
            }
            return filter;
        }
        return null;
    }

    @Nullable
    public static IFilter<?> readFromPacket(PacketBuffer dataStream) {
        IFilter<?> filter = BaseFilter.fromType((FilterType)dataStream.func_179257_a(FilterType.class));
        if (filter != null) {
            filter.read(dataStream);
        }
        return filter;
    }

    private static IFilter<?> fromType(FilterType filterType) {
        switch (filterType) {
            case MINER_ITEMSTACK_FILTER: {
                return new MItemStackFilter();
            }
            case MINER_MATERIAL_FILTER: {
                return new MMaterialFilter();
            }
            case MINER_MODID_FILTER: {
                return new MModIDFilter();
            }
            case MINER_TAG_FILTER: {
                return new MTagFilter();
            }
            case SORTER_ITEMSTACK_FILTER: {
                return new TItemStackFilter();
            }
            case SORTER_MATERIAL_FILTER: {
                return new TMaterialFilter();
            }
            case SORTER_MODID_FILTER: {
                return new TModIDFilter();
            }
            case SORTER_TAG_FILTER: {
                return new TTagFilter();
            }
            case OREDICTIONIFICATOR: {
                return new TileEntityOredictionificator.OredictionificatorFilter();
            }
        }
        return null;
    }
}

