/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.attribute;

import java.util.Collection;
import javax.annotation.Nonnull;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.states.BlockStateHelper;
import net.minecraft.block.BlockState;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;

public class AttributeStateFacing
implements Attribute {
    private DirectionProperty facingProperty;
    private FacePlacementType placementType;

    public AttributeStateFacing() {
        this(BlockStateHelper.horizontalFacingProperty);
    }

    public AttributeStateFacing(DirectionProperty facingProperty) {
        this(facingProperty, FacePlacementType.PLAYER_LOCATION);
    }

    public AttributeStateFacing(DirectionProperty facingProperty, FacePlacementType placementType) {
        this.facingProperty = facingProperty;
        this.placementType = placementType;
    }

    public Direction getDirection(BlockState state) {
        return (Direction)state.func_177229_b((IProperty)this.getFacingProperty());
    }

    public BlockState setDirection(@Nonnull BlockState state, Direction newDirection) {
        return this.supportsDirection(newDirection) ? (BlockState)state.func_206870_a((IProperty)this.getFacingProperty(), (Comparable)newDirection) : state;
    }

    @Nonnull
    public DirectionProperty getFacingProperty() {
        return this.facingProperty;
    }

    @Nonnull
    public FacePlacementType getPlacementType() {
        return this.placementType;
    }

    public Collection<Direction> getSupportedDirections() {
        return this.getFacingProperty().func_177700_c();
    }

    public boolean supportsDirection(Direction direction) {
        return this.getSupportedDirections().contains(direction);
    }

    public static enum FacePlacementType {
        PLAYER_LOCATION,
        SELECTED_FACE;

    }
}

