/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.filter;

import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.ColorButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.filter.GuiModIDFilter;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.TagCache;
import mekanism.common.content.transporter.TModIDFilter;
import mekanism.common.inventory.container.tile.filter.LSModIDFilterContainer;
import mekanism.common.network.PacketEditFilter;
import mekanism.common.network.PacketGuiButtonPress;
import mekanism.common.network.PacketNewFilter;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.TransporterUtils;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiTModIDFilter
extends GuiModIDFilter<TModIDFilter, TileEntityLogisticalSorter, LSModIDFilterContainer> {
    public GuiTModIDFilter(LSModIDFilterContainer container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.origFilter = container.getOrigFilter();
        this.filter = container.getFilter();
        this.isNew = container.isNew();
    }

    @Override
    protected void updateStackList(String modName) {
        this.iterStacks = TagCache.getModIDStacks(modName, false);
        this.stackSwitch = 0;
        this.stackIndex = -1;
    }

    @Override
    protected void addButtons() {
        this.addButton(new GuiInnerScreen(this, 33, 18, 111, 43));
        this.addButton(new GuiInnerScreen(this, 130, 46, 14, 14));
        this.addButton(new GuiSlot(SlotType.NORMAL, this, 11, 18));
        this.addButton(new GuiSlot(SlotType.NORMAL, this, 11, 43));
        this.saveButton = new TranslationButton(this, this.getGuiLeft() + 47, this.getGuiTop() + 62, 60, 20, MekanismLang.BUTTON_SAVE, () -> {
            if (!this.text.func_146179_b().isEmpty()) {
                this.setText();
            }
            if (((TModIDFilter)this.filter).getModID() != null && !((TModIDFilter)this.filter).getModID().isEmpty()) {
                if (this.isNew) {
                    Mekanism.packetHandler.sendToServer(new PacketNewFilter(((TileEntityLogisticalSorter)this.tile).func_174877_v(), this.filter));
                } else {
                    Mekanism.packetHandler.sendToServer(new PacketEditFilter(((TileEntityLogisticalSorter)this.tile).func_174877_v(), false, this.origFilter, this.filter));
                }
                this.sendPacketToServer(PacketGuiButtonPress.ClickedTileButton.BACK_BUTTON);
            } else {
                this.status = MekanismLang.MODID_FILTER_NO_ID.translateColored(EnumColor.DARK_RED, new Object[0]);
                this.ticker = 20;
            }
        });
        this.addButton(this.saveButton);
        this.deleteButton = new TranslationButton(this, this.getGuiLeft() + 109, this.getGuiTop() + 62, 60, 20, MekanismLang.BUTTON_DELETE, () -> {
            Mekanism.packetHandler.sendToServer(new PacketEditFilter(((TileEntityLogisticalSorter)this.tile).func_174877_v(), true, this.origFilter, null));
            this.sendPacketToServer(PacketGuiButtonPress.ClickedTileButton.BACK_BUTTON);
        });
        this.addButton(this.deleteButton);
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 5, this.getGuiTop() + 5, 11, 14, this.getButtonLocation("back"), () -> this.sendPacketToServer(this.isNew ? PacketGuiButtonPress.ClickedTileButton.LS_SELECT_FILTER_TYPE : PacketGuiButtonPress.ClickedTileButton.BACK_BUTTON)));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 11, this.getGuiTop() + 64, 11, this.getButtonLocation("default"), () -> {
            ((TModIDFilter)this.filter).allowDefault = !((TModIDFilter)this.filter).allowDefault;
        }, this.getOnHover(MekanismLang.FILTER_ALLOW_DEFAULT)));
        this.checkboxButton = new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 131, this.getGuiTop() + 47, 12, this.getButtonLocation("checkmark"), this::setText);
        this.addButton(this.checkboxButton);
        this.addButton(new ColorButton((IGuiWrapper)this, this.getGuiLeft() + 12, this.getGuiTop() + 44, 16, 16, () -> ((TModIDFilter)this.filter).color, () -> {
            ((TModIDFilter)this.filter).color = GuiTModIDFilter.hasShiftDown() ? null : TransporterUtils.increment(((TModIDFilter)this.filter).color);
        }, () -> {
            ((TModIDFilter)this.filter).color = TransporterUtils.decrement(((TModIDFilter)this.filter).color);
        }));
    }
}

