/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.math;

import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.function.IntSupplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.math.FloatingLong;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FloatingLongTransferUtils {
    public static FloatingLong insert(FloatingLong stack, Action action, IntSupplier containerCount, Int2ObjectFunction<FloatingLong> inContainerGetter, InsertFloatingLong insert) {
        FloatingLong remainder;
        int container;
        int containers = containerCount.getAsInt();
        if (containers == 1) {
            return insert.insert(0, stack, action);
        }
        IntArrayList matchingContainers = new IntArrayList();
        IntArrayList emptyContainers = new IntArrayList();
        for (int container2 = 0; container2 < containers; ++container2) {
            FloatingLong inContainer = (FloatingLong)inContainerGetter.apply(container2);
            if (inContainer.isZero()) {
                emptyContainers.add(container2);
                continue;
            }
            matchingContainers.add(container2);
        }
        FloatingLong toInsert = stack;
        IntListIterator intListIterator = matchingContainers.iterator();
        while (intListIterator.hasNext()) {
            container = (Integer)intListIterator.next();
            remainder = insert.insert(container, toInsert, action);
            if (remainder.isZero()) {
                return FloatingLong.ZERO;
            }
            toInsert = remainder;
        }
        intListIterator = emptyContainers.iterator();
        while (intListIterator.hasNext()) {
            container = (Integer)intListIterator.next();
            remainder = insert.insert(container, toInsert, action);
            if (remainder.isZero()) {
                return FloatingLong.ZERO;
            }
            toInsert = remainder;
        }
        return toInsert;
    }

    public static FloatingLong extract(FloatingLong amount, Action action, IntSupplier containerCount, ExtractFloatingLong extract) {
        int containers = containerCount.getAsInt();
        if (containers == 1) {
            return extract.extract(0, amount, action);
        }
        FloatingLong extracted = FloatingLong.ZERO;
        FloatingLong toExtract = amount.copy();
        for (int container = 0; container < containers; ++container) {
            FloatingLong drained = extract.extract(container, toExtract, action);
            if (drained.isZero()) continue;
            extracted = extracted.isZero() ? drained : extracted.plusEqual(drained);
            if ((toExtract = toExtract.minusEqual(drained)).isZero()) break;
        }
        return extracted;
    }

    @FunctionalInterface
    public static interface ExtractFloatingLong {
        public FloatingLong extract(int var1, FloatingLong var2, Action var3);
    }

    @FunctionalInterface
    public static interface InsertFloatingLong {
        public FloatingLong insert(int var1, FloatingLong var2, Action var3);
    }
}

