/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.datagen.recipe.RecipeCriterion;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class MekanismRecipeBuilder<BUILDER extends MekanismRecipeBuilder<BUILDER>> {
    protected final List<ICondition> conditions = new ArrayList<ICondition>();
    protected final Advancement.Builder advancementBuilder = Advancement.Builder.func_200278_a();
    protected final ResourceLocation serializerName;

    protected MekanismRecipeBuilder(ResourceLocation serializerName) {
        this.serializerName = serializerName;
    }

    public BUILDER addCriterion(RecipeCriterion criterion) {
        return this.addCriterion(criterion.name, criterion.criterion);
    }

    public BUILDER addCriterion(String name, ICriterionInstance criterion) {
        this.advancementBuilder.func_200275_a(name, criterion);
        return (BUILDER)this;
    }

    public BUILDER addCondition(ICondition condition) {
        this.conditions.add(condition);
        return (BUILDER)this;
    }

    protected boolean hasCriteria() {
        return !this.advancementBuilder.func_200277_c().isEmpty();
    }

    protected abstract RecipeResult getResult(ResourceLocation var1);

    protected void validate(ResourceLocation id) {
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        this.validate(id);
        if (this.hasCriteria()) {
            this.advancementBuilder.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)new RecipeUnlockedTrigger.Instance(id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        }
        consumer.accept(this.getResult(id));
    }

    protected abstract class RecipeResult
    implements IFinishedRecipe {
        private final ResourceLocation id;

        public RecipeResult(ResourceLocation id) {
            this.id = id;
        }

        public JsonObject func_200441_a() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("type", MekanismRecipeBuilder.this.serializerName.toString());
            if (!MekanismRecipeBuilder.this.conditions.isEmpty()) {
                JsonArray conditionsArray = new JsonArray();
                for (ICondition condition : MekanismRecipeBuilder.this.conditions) {
                    conditionsArray.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
                }
                jsonObject.add("conditions", (JsonElement)conditionsArray);
            }
            this.func_218610_a(jsonObject);
            return jsonObject;
        }

        @Nonnull
        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(MekanismRecipeBuilder.this.serializerName);
        }

        @Nonnull
        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return MekanismRecipeBuilder.this.hasCriteria() ? MekanismRecipeBuilder.this.advancementBuilder.func_200273_b() : null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return new ResourceLocation(this.id.func_110624_b(), "recipes/" + this.id.func_110623_a());
        }
    }
}

