/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.tileentity;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.colossalchests.GeneralConfig;
import org.cyclops.colossalchests.RegistryEntries;
import org.cyclops.colossalchests.block.ChestMaterial;
import org.cyclops.colossalchests.block.ColossalChestConfig;
import org.cyclops.colossalchests.inventory.container.ContainerColossalChest;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.DirectionHelpers;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.cyclopscore.inventory.INBTInventory;
import org.cyclops.cyclopscore.inventory.IndexedInventory;
import org.cyclops.cyclopscore.inventory.LargeInventory;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;

public class TileColossalChest
extends CyclopsTileEntity
implements CyclopsTileEntity.ITickingTile,
INamedContainerProvider,
IChestLid {
    private static final int TICK_MODULUS = 200;
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    private SimpleInventory lastValidInventory = null;
    private SimpleInventory inventory = null;
    private LazyOptional<IItemHandler> capabilityItemHandler = LazyOptional.empty();
    @NBTPersist
    private Vec3i size = LocationHelpers.copyLocation((Vec3i)Vec3i.field_177959_e);
    @NBTPersist
    private Vec3d renderOffset = new Vec3d(0.0, 0.0, 0.0);
    private ITextComponent customName = null;
    @NBTPersist
    private int materialId = 0;
    @NBTPersist
    private int rotation = 0;
    @NBTPersist(useDefaultValue=false)
    private List<Vec3i> interfaceLocations = Lists.newArrayList();
    public float prevLidAngle;
    public float lidAngle;
    private int playersUsing;
    private boolean recreateNullInventory = true;
    private EnumFacingMap<int[]> facingSlots = EnumFacingMap.newMap();

    public TileColossalChest() {
        super(RegistryEntries.TILE_ENTITY_COLOSSAL_CHEST);
    }

    public Vec3i getSize() {
        return this.size;
    }

    public void setSize(Vec3i size) {
        this.size = size;
        this.facingSlots.clear();
        if (this.isStructureComplete()) {
            this.setInventory((SimpleInventory)this.constructInventory());
            this.inventory.addDirtyMarkListener((IDirtyMarkListener)this);
            if (this.lastValidInventory != null) {
                int slot;
                for (slot = 0; slot < Math.min(this.lastValidInventory.func_70302_i_(), this.inventory.func_70302_i_()); ++slot) {
                    ItemStack contents = this.lastValidInventory.func_70301_a(slot);
                    if (contents.func_190926_b()) continue;
                    this.inventory.func_70299_a(slot, contents);
                    this.lastValidInventory.func_70299_a(slot, ItemStack.field_190927_a);
                }
                if (slot < this.lastValidInventory.func_70302_i_()) {
                    InventoryHelpers.dropItems((World)this.func_145831_w(), (IInventory)this.lastValidInventory, (BlockPos)this.func_174877_v());
                }
                this.lastValidInventory = null;
            }
        } else {
            this.interfaceLocations.clear();
            if (this.inventory != null) {
                if (GeneralConfig.ejectItemsOnDestroy) {
                    InventoryHelpers.dropItems((World)this.func_145831_w(), (IInventory)this.inventory, (BlockPos)this.func_174877_v());
                    this.lastValidInventory = null;
                } else {
                    this.lastValidInventory = this.inventory;
                }
            }
            this.setInventory((SimpleInventory)new LargeInventory(0, 0));
        }
        this.sendUpdate();
    }

    public void setMaterial(ChestMaterial material) {
        this.materialId = material.ordinal();
    }

    public ChestMaterial getMaterial() {
        return ChestMaterial.VALUES.get(this.materialId);
    }

    public SimpleInventory getLastValidInventory() {
        return this.lastValidInventory;
    }

    public void setLastValidInventory(SimpleInventory lastValidInventory) {
        this.lastValidInventory = lastValidInventory;
    }

    public int getSizeSingular() {
        return this.getSize().func_177958_n() + 1;
    }

    protected boolean isClientSide() {
        return this.func_145831_w() != null && this.func_145831_w().field_72995_K;
    }

    protected LargeInventory constructInventory() {
        if (!this.isClientSide() && GeneralConfig.creativeChests) {
            return this.constructInventoryDebug();
        }
        return !this.isClientSide() ? new IndexedInventory(this.calculateInventorySize(), 64){

            public void func_174889_b(PlayerEntity entityPlayer) {
                if (!entityPlayer.func_175149_v()) {
                    super.func_174889_b(entityPlayer);
                    TileColossalChest.this.triggerPlayerUsageChange(1);
                }
            }

            public void func_174886_c(PlayerEntity entityPlayer) {
                if (!entityPlayer.func_175149_v()) {
                    super.func_174886_c(entityPlayer);
                    TileColossalChest.this.triggerPlayerUsageChange(-1);
                }
            }
        } : new LargeInventory(this.calculateInventorySize(), 64);
    }

    protected LargeInventory constructInventoryDebug() {
        IndexedInventory inv = !this.isClientSide() ? new IndexedInventory(this.calculateInventorySize(), 64) : new LargeInventory(this.calculateInventorySize(), 64);
        Random random = new Random();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            inv.func_70299_a(i, new ItemStack((IItemProvider)Iterables.get((Iterable)ForgeRegistries.ITEMS.getValues(), (int)random.nextInt(ForgeRegistries.ITEMS.getValues().size()))));
        }
        return inv;
    }

    public CompoundNBT func_189517_E_() {
        SimpleInventory oldInventory = this.inventory;
        SimpleInventory oldLastInventory = this.lastValidInventory;
        this.inventory = null;
        this.lastValidInventory = null;
        this.recreateNullInventory = false;
        CompoundNBT tag = super.func_189517_E_();
        this.inventory = oldInventory;
        this.lastValidInventory = oldLastInventory;
        this.recreateNullInventory = true;
        return tag;
    }

    public void func_145839_a(CompoundNBT tag) {
        SimpleInventory oldInventory = this.inventory;
        SimpleInventory oldLastInventory = this.lastValidInventory;
        if (this.func_145831_w() != null && this.func_145831_w().field_72995_K) {
            this.inventory = null;
            this.lastValidInventory = null;
            this.recreateNullInventory = false;
        }
        super.func_145839_a(tag);
        if (this.func_145831_w() != null && this.func_145831_w().field_72995_K) {
            this.inventory = oldInventory;
            this.lastValidInventory = oldLastInventory;
            this.recreateNullInventory = true;
        } else {
            this.getInventory().read(tag.func_74775_l("inventory"));
            if (tag.func_150297_b("lastValidInventory", 10)) {
                this.lastValidInventory = new LargeInventory(tag.func_74762_e("lastValidInventorySize"), this.inventory.func_70297_j_());
                this.lastValidInventory.read(tag.func_74775_l("lastValidInventory"));
            }
        }
        if (tag.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_150699_a((String)tag.func_74779_i("CustomName"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        CompoundNBT subTag;
        if (this.customName != null) {
            tag.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        if (this.inventory != null) {
            subTag = new CompoundNBT();
            this.inventory.write(subTag);
            tag.func_218657_a("inventory", (INBT)subTag);
        }
        if (this.lastValidInventory != null) {
            subTag = new CompoundNBT();
            this.lastValidInventory.write(subTag);
            tag.func_218657_a("lastValidInventory", (INBT)subTag);
            tag.func_74768_a("lastValidInventorySize", this.lastValidInventory.func_70302_i_());
        }
        return super.func_189515_b(tag);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, this.func_189517_E_());
    }

    protected int calculateInventorySize() {
        int size = this.getSizeSingular();
        if (size == 1) {
            return 0;
        }
        return (int)Math.ceil(Math.pow(size, 3.0) * 27.0 * this.getMaterial().getInventoryMultiplier() / 9.0) * 9;
    }

    public void updateTileEntity() {
        super.updateTileEntity();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.playersUsing != 0 && WorldHelpers.efficientTick((World)this.field_145850_b, (int)200, (int[])new int[]{this.func_174877_v().hashCode()})) {
            this.playersUsing = 0;
            float range = 5.0f;
            List entities = this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB(this.func_174877_v().func_177971_a(new Vec3i((double)(-range), (double)(-range), (double)(-range))), this.func_174877_v().func_177971_a(new Vec3i((double)(1.0f + range), (double)(1.0f + range), (double)(1.0f + range)))));
            for (PlayerEntity player : entities) {
                if (!(player.field_71070_bA instanceof ContainerColossalChest)) continue;
                ++this.playersUsing;
            }
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 1, this.playersUsing);
        }
        this.prevLidAngle = this.lidAngle;
        float increaseAngle = 0.15f / (float)Math.min(5, this.getSizeSingular());
        if (this.playersUsing > 0 && this.lidAngle == 0.0f) {
            this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, SoundEvents.field_187657_V, SoundCategory.BLOCKS, (float)(0.5 + 0.5 * Math.log(this.getSizeSingular())), this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.45f + increaseAngle, true);
        }
        if (this.playersUsing == 0 && this.lidAngle > 0.0f || this.playersUsing > 0 && this.lidAngle < 1.0f) {
            float closedAngle;
            float preIncreaseAngle = this.lidAngle;
            this.lidAngle = this.playersUsing > 0 ? (this.lidAngle += increaseAngle) : (this.lidAngle -= increaseAngle);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (closedAngle = 0.5f) && preIncreaseAngle >= closedAngle) {
                this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, SoundEvents.field_187651_T, SoundCategory.BLOCKS, (float)(0.5 + 0.5 * Math.log(this.getSizeSingular())), this.field_145850_b.field_73012_v.nextFloat() * 0.05f + 0.45f + increaseAngle, true);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 1) {
            this.playersUsing = j;
        }
        return true;
    }

    private void triggerPlayerUsageChange(int change) {
        if (this.field_145850_b != null) {
            this.playersUsing += change;
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 1, this.playersUsing);
        }
    }

    public void setInventory(SimpleInventory inventory) {
        this.capabilityItemHandler.invalidate();
        this.inventory = inventory;
        if (this.inventory.func_70302_i_() > 0) {
            InvWrapper itemHandler = new InvWrapper((IInventory)this.inventory);
            this.capabilityItemHandler = LazyOptional.of(() -> TileColossalChest.lambda$setInventory$0((IItemHandler)itemHandler));
        } else {
            this.capabilityItemHandler = LazyOptional.empty();
        }
    }

    protected void ensureInventoryInitialized() {
        if (this.func_145831_w() != null && this.func_145831_w().field_72995_K && (this.inventory == null || this.inventory.func_70302_i_() != this.calculateInventorySize())) {
            this.setInventory((SimpleInventory)this.constructInventory());
        }
    }

    public INBTInventory getInventory() {
        if (this.lastValidInventory != null) {
            return new IndexedInventory();
        }
        this.ensureInventoryInitialized();
        if (this.inventory == null && this.recreateNullInventory) {
            this.setInventory((SimpleInventory)this.constructInventory());
        }
        return this.inventory;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        this.ensureInventoryInitialized();
        if (this.capabilityItemHandler.isPresent() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.capabilityItemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public boolean canInteractWith(PlayerEntity entityPlayer) {
        return this.getSizeSingular() > 1 && super.canInteractWith(entityPlayer);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        int size = this.getSizeSingular();
        return new AxisAlignedBB(this.func_174877_v().func_177973_b(new Vec3i(size, size, size)), this.func_174877_v().func_177982_a(size, size * 2, size));
    }

    public void setCenter(Vec3d center) {
        double dx = Math.abs(center.field_72450_a - (double)this.func_174877_v().func_177958_n());
        double dz = Math.abs(center.field_72449_c - (double)this.func_174877_v().func_177952_p());
        boolean equal = center.field_72450_a - (double)this.func_174877_v().func_177958_n() == center.field_72449_c - (double)this.func_174877_v().func_177952_p();
        Direction rotation = dx > dz || !equal && this.getSizeSingular() == 2 ? DirectionHelpers.getEnumFacingFromXSign((int)((int)Math.round(center.field_72450_a - (double)this.func_174877_v().func_177958_n()))) : DirectionHelpers.getEnumFacingFromZSing((int)((int)Math.round(center.field_72449_c - (double)this.func_174877_v().func_177952_p())));
        this.setRotation(rotation);
        this.renderOffset = new Vec3d((double)this.func_174877_v().func_177958_n() - center.field_72450_a, (double)this.func_174877_v().func_177956_o() - center.field_72448_b, (double)this.func_174877_v().func_177952_p() - center.field_72449_c);
    }

    public void setRotation(Direction rotation) {
        this.rotation = rotation.ordinal();
    }

    public Direction getRotation() {
        return Direction.func_82600_a((int)this.rotation);
    }

    public Vec3d getRenderOffset() {
        return this.renderOffset;
    }

    public void setRenderOffset(Vec3d renderOffset) {
        this.renderOffset = renderOffset;
    }

    public static void detectStructure(IWorldReader world, BlockPos location, Vec3i size, boolean valid, BlockPos originCorner) {
    }

    public boolean isStructureComplete() {
        return !this.getSize().equals((Object)Vec3i.field_177959_e);
    }

    public static Vec3i getMaxSize() {
        int size = ColossalChestConfig.maxSize;
        return new Vec3i(size, size, size);
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    public void setCustomName(ITextComponent name) {
        this.customName = name;
    }

    public void addInterface(Vec3i blockPos) {
        this.interfaceLocations.add(blockPos);
    }

    public List<Vec3i> getInterfaceLocations() {
        return Collections.unmodifiableList(this.interfaceLocations);
    }

    public ITextComponent func_145748_c_() {
        return this.hasCustomName() ? this.customName : new TranslationTextComponent("general.colossalchests.colossalchest", new Object[]{new TranslationTextComponent(this.getMaterial().getUnlocalizedName(), new Object[0]), this.getSizeSingular()});
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerColossalChest(id, playerInventory, (IInventory)this.getInventory());
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_195480_a(float partialTicks) {
        return ColossalChestConfig.chestAnimation ? MathHelper.func_219799_g((float)partialTicks, (float)this.prevLidAngle, (float)this.lidAngle) : 0.0f;
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }

    private static /* synthetic */ IItemHandler lambda$setInventory$0(IItemHandler itemHandler) {
        return itemHandler;
    }
}

