/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.net;

import com.feed_the_beast.mods.ftbchunks.FTBChunks;
import com.feed_the_beast.mods.ftbchunks.FTBChunksConfig;
import com.feed_the_beast.mods.ftbchunks.api.ClaimedChunk;
import com.feed_the_beast.mods.ftbchunks.api.FTBChunksAPI;
import com.feed_the_beast.mods.ftbchunks.net.FTBChunksNet;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class SendGeneralDataPacket {
    public int claimed;
    public int loaded;
    public int maxClaimed;
    public int maxLoaded;

    public static void send(ServerPlayerEntity player) {
        SendGeneralDataPacket data = new SendGeneralDataPacket();
        data.maxClaimed = FTBChunksConfig.getMaxClaimedChunks(player);
        data.maxLoaded = FTBChunksConfig.getMaxForceLoadedChunks(player);
        for (ClaimedChunk chunk : FTBChunksAPI.INSTANCE.getManager().getData(player).getClaimedChunks()) {
            ++data.claimed;
            if (!chunk.isForceLoaded()) continue;
            ++data.loaded;
        }
        FTBChunksNet.MAIN.send(PacketDistributor.PLAYER.with(() -> player), (Object)data);
    }

    public SendGeneralDataPacket() {
    }

    SendGeneralDataPacket(PacketBuffer buf) {
        this.claimed = buf.func_150792_a();
        this.loaded = buf.func_150792_a();
        this.maxClaimed = buf.func_150792_a();
        this.maxLoaded = buf.func_150792_a();
    }

    void write(PacketBuffer buf) {
        buf.func_150787_b(this.claimed);
        buf.func_150787_b(this.loaded);
        buf.func_150787_b(this.maxClaimed);
        buf.func_150787_b(this.maxLoaded);
    }

    void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> FTBChunks.instance.proxy.updateGeneralData(this));
        context.get().setPacketHandled(true);
    }
}

