/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.client;

import com.feed_the_beast.mods.ftbchunks.api.Waypoint;
import com.feed_the_beast.mods.ftbchunks.api.WaypointType;
import com.feed_the_beast.mods.ftbchunks.client.LargeMapScreen;
import com.feed_the_beast.mods.ftbchunks.net.ChangeWaypointColorPacket;
import com.feed_the_beast.mods.ftbchunks.net.ChangeWaypointNamePacket;
import com.feed_the_beast.mods.ftbchunks.net.DeleteWaypointPacket;
import com.feed_the_beast.mods.ftbchunks.net.FTBChunksNet;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigString;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.utils.MathUtils;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.ContextMenuItem;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiIcons;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.Widget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class WaypointButton
extends Widget {
    public final Waypoint waypoint;
    public Icon icon;

    public WaypointButton(Panel panel, Waypoint w) {
        super(panel);
        this.icon = Icon.getIcon((ResourceLocation)w.type.texture).withTint(Color4I.rgb((int)w.color));
        this.waypoint = w;
    }

    public void addMouseOverText(List<String> list) {
        list.add(this.waypoint.name);
        if (!this.waypoint.owner.isEmpty()) {
            list.add(TextFormatting.GRAY + this.waypoint.owner);
        }
    }

    public void draw(Theme theme, int x, int y, int w, int h) {
        this.icon.draw(x, y, w, h);
    }

    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver() && button.isRight()) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem(this.waypoint.name, this.icon, () -> {}));
            contextMenu.add(ContextMenuItem.SEPARATOR);
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"gui.rename", (Object[])new Object[0]), GuiIcons.CHAT, () -> {
                ConfigString config = new ConfigString();
                config.defaultValue = "";
                config.value = this.waypoint.name;
                config.onClicked(MouseButton.LEFT, b -> {
                    if (b) {
                        this.waypoint.name = (String)config.value;
                        FTBChunksNet.MAIN.sendToServer((Object)new ChangeWaypointNamePacket(this.waypoint.id, this.waypoint.name));
                    }
                    this.openGui();
                });
            }));
            if (this.waypoint.type == WaypointType.DEFAULT) {
                contextMenu.add(new ContextMenuItem("Change Color", GuiIcons.COLOR_RGB, () -> {
                    Color4I col = Color4I.hsb((float)MathUtils.RAND.nextFloat(), (float)1.0f, (float)1.0f);
                    this.icon = Icon.getIcon((ResourceLocation)this.waypoint.type.texture).withTint(col);
                    FTBChunksNet.MAIN.sendToServer((Object)new ChangeWaypointColorPacket(this.waypoint.id, col.rgba()));
                    ((ContextMenuItem)contextMenu.get((int)0)).icon = this.icon;
                }).setCloseMenu(false));
            }
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"gui.remove", (Object[])new Object[0]), GuiIcons.REMOVE, () -> {
                ((LargeMapScreen)this.getGui()).dimension.waypoints.remove(this.waypoint);
                this.parent.widgets.remove((Object)this);
                FTBChunksNet.MAIN.sendToServer((Object)new DeleteWaypointPacket(this.waypoint.id));
            }));
            this.getGui().openContextMenu(contextMenu);
            return true;
        }
        return false;
    }
}

