/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.client;

import com.feed_the_beast.mods.ftbchunks.client.MinimapPosition;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.config.NameMap;
import com.feed_the_beast.mods.ftbguilibrary.config.gui.GuiEditConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

public class FTBChunksClientConfig {
    public static double noise;
    public static MinimapPosition minimap;
    public static double minimapScale;
    public static boolean minimapWaypoints;
    public static boolean minimapPlayerHeads;
    public static boolean minimapXYZ;
    public static boolean minimapBiome;
    public static boolean minimapBlur;
    public static boolean minimapCompass;
    private static Pair<ClientConfig, ForgeConfigSpec> client;

    public static void init() {
        FMLJavaModLoadingContext.get().getModEventBus().register(FTBChunksClientConfig.class);
        client = new ForgeConfigSpec.Builder().configure(x$0 -> new ClientConfig((ForgeConfigSpec.Builder)x$0));
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, (ForgeConfigSpec)client.getRight());
    }

    @SubscribeEvent
    public static void reload(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == client.getRight()) {
            ClientConfig c = (ClientConfig)client.getLeft();
            noise = (Double)c.noise.get();
            minimap = (MinimapPosition)((Object)c.minimap.get());
            minimapScale = (Double)c.minimapScale.get();
            minimapWaypoints = (Boolean)c.minimapWaypoints.get();
            minimapPlayerHeads = (Boolean)c.minimapPlayerHeads.get();
            minimapXYZ = (Boolean)c.minimapXYZ.get();
            minimapBiome = (Boolean)c.minimapBiome.get();
            minimapBlur = (Boolean)c.minimapBlur.get();
            minimapCompass = (Boolean)c.minimapCompass.get();
        }
    }

    public static void openSettings() {
        ConfigGroup group = new ConfigGroup("ftbchunks");
        group.addDouble("noise", noise, v -> {
            ((ClientConfig)FTBChunksClientConfig.client.getLeft()).noise.set(v);
            noise = v;
        }, 0.05, 0.0, 0.5);
        group.addEnum("minimap", (Object)minimap, v -> {
            ((ClientConfig)client.getLeft()).minimap.set((Object)v);
            minimap = v;
        }, NameMap.of((Object)((Object)MinimapPosition.TOP_RIGHT), (Object[])MinimapPosition.values()).create());
        group.addDouble("minimap_scale", minimapScale, v -> {
            ((ClientConfig)FTBChunksClientConfig.client.getLeft()).minimapScale.set(v);
            minimapScale = v;
        }, 1.0, 0.25, 4.0);
        group.addBool("minimap_waypoints", minimapWaypoints, v -> {
            ((ClientConfig)FTBChunksClientConfig.client.getLeft()).minimapWaypoints.set(v);
            minimapWaypoints = v;
        }, true);
        group.addBool("minimap_player_heads", minimapPlayerHeads, v -> {
            ((ClientConfig)FTBChunksClientConfig.client.getLeft()).minimapPlayerHeads.set(v);
            minimapPlayerHeads = v;
        }, true);
        group.addBool("minimap_xyz", minimapXYZ, v -> {
            ((ClientConfig)FTBChunksClientConfig.client.getLeft()).minimapXYZ.set(v);
            minimapXYZ = v;
        }, true);
        group.addBool("minimap_biome", minimapBiome, v -> {
            ((ClientConfig)FTBChunksClientConfig.client.getLeft()).minimapBiome.set(v);
            minimapBiome = v;
        }, true);
        group.addBool("minimap_blur", minimapBlur, v -> {
            ((ClientConfig)FTBChunksClientConfig.client.getLeft()).minimapBlur.set(v);
            minimapBlur = v;
        }, true);
        group.addBool("minimap_compass", minimapCompass, v -> {
            ((ClientConfig)FTBChunksClientConfig.client.getLeft()).minimapCompass.set(v);
            minimapCompass = v;
        }, true);
        GuiEditConfig gui = new GuiEditConfig(group);
        group.savedCallback = b -> {
            if (b) {
                ((ForgeConfigSpec)client.getRight()).save();
            }
            gui.closeGui(false);
        };
        gui.openGui();
    }

    private static class ClientConfig {
        public final ForgeConfigSpec.DoubleValue noise;
        private final ForgeConfigSpec.EnumValue<MinimapPosition> minimap;
        public final ForgeConfigSpec.DoubleValue minimapScale;
        public final ForgeConfigSpec.BooleanValue minimapWaypoints;
        public final ForgeConfigSpec.BooleanValue minimapPlayerHeads;
        public final ForgeConfigSpec.BooleanValue minimapXYZ;
        public final ForgeConfigSpec.BooleanValue minimapBiome;
        public final ForgeConfigSpec.BooleanValue minimapBlur;
        public final ForgeConfigSpec.BooleanValue minimapCompass;

        private ClientConfig(ForgeConfigSpec.Builder builder) {
            this.noise = builder.comment("Noise added to map to make it look less plastic").translation("ftbchunks.noise").defineInRange("noise", 0.05, 0.0, 0.5);
            this.minimap = builder.comment("Enables minimap to show up in corner").translation("ftbchunks.minimap").defineEnum("minimap", (Enum)MinimapPosition.TOP_RIGHT);
            this.minimapScale = builder.comment("Scale of minimap").translation("ftbchunks.minimap_scale").defineInRange("minimap_scale", 1.0, 0.25, 4.0);
            this.minimapWaypoints = builder.comment("Show waypoints on minimap").translation("ftbchunks.minimap_waypoints").define("minimap_waypoints", true);
            this.minimapPlayerHeads = builder.comment("Show player heads on minimap").translation("ftbchunks.minimap_player_heads").define("minimap_player_heads", true);
            this.minimapXYZ = builder.comment("Show XYZ under minimap").translation("ftbchunks.minimap_xyz").define("minimap_xyz", true);
            this.minimapBiome = builder.comment("Show biome under minimap").translation("ftbchunks.minimap_biome").define("minimap_biome", true);
            this.minimapBlur = builder.comment("Blurs minimap").translation("ftbchunks.minimap_blur").define("minimap_blur", true);
            this.minimapCompass = builder.comment("Adds NWSE compass inside minimap").translation("ftbchunks.minimap_compass").define("minimap_compass", true);
        }
    }
}

