/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.multiblock;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Map;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.common.multiblock.DenseMultiblock;
import vazkii.patchouli.common.multiblock.StringStateMatcher;

public class SerializedMultiblock {
    public String[][] pattern = new String[0][0];
    public Map<String, String> mapping = new HashMap<String, String>();
    boolean symmetrical = false;
    int[] offset = new int[]{0, 0, 0};

    public DenseMultiblock toMultiblock() {
        String allowed = "0_ ";
        String[][] stringArray = this.pattern;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] line;
            for (String s : line = stringArray[i]) {
                for (char c : s.toCharArray()) {
                    if ("0_ ".indexOf(c) != -1 || this.mapping.containsKey(String.valueOf(c))) continue;
                    throw new IllegalArgumentException("Character " + c + " in multiblock isn't mapped to a block");
                }
            }
        }
        Object[] targets = new Object[this.mapping.size() * 2];
        int i = 0;
        for (Map.Entry<String, String> e : this.mapping.entrySet()) {
            IStateMatcher matcher;
            String key = e.getKey();
            String value = e.getValue();
            if (key.length() != 1) {
                throw new IllegalArgumentException(key + " is an invalid mapping key, every mapping key must be 1 character long");
            }
            char keyChar = key.charAt(0);
            try {
                matcher = StringStateMatcher.fromString(value);
            }
            catch (CommandSyntaxException ex) {
                throw new IllegalArgumentException("Failure parsing state matcher", ex);
            }
            targets[i] = Character.valueOf(keyChar);
            targets[i + 1] = matcher;
            i += 2;
        }
        DenseMultiblock mb = new DenseMultiblock(this.pattern, targets);
        mb.setSymmetrical(this.symmetrical);
        mb.offset(this.offset[0], this.offset[1], this.offset[2]);
        return mb;
    }
}

