/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.book;

import java.io.File;
import java.io.FileInputStream;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.book.BookRegistry;

public class BookFolderLoader {
    public static File loadDir;

    private static void setup() {
        loadDir = new File("patchouli_books");
        if (!loadDir.exists()) {
            loadDir.mkdir();
        } else if (!loadDir.isDirectory()) {
            throw new RuntimeException(loadDir.getAbsolutePath() + " is a file, not a folder, aborting. Please delete this file or move it elsewhere if it has important contents.");
        }
    }

    public static void findBooks() {
        if (loadDir == null) {
            BookFolderLoader.setup();
        }
        IModInfo mod = ModLoadingContext.get().getActiveContainer().getModInfo();
        File[] subdirs = loadDir.listFiles(File::isDirectory);
        if (subdirs == null) {
            Patchouli.LOGGER.warn("Failed to list external books in {}, not loading external books", (Object)loadDir.getAbsolutePath());
            return;
        }
        for (File dir : subdirs) {
            ResourceLocation res;
            try {
                res = new ResourceLocation("patchouli", dir.getName());
            }
            catch (ResourceLocationException ex) {
                Patchouli.LOGGER.error("Invalid external book folder name {}, skipping", (Object)dir.getName(), (Object)ex);
                continue;
            }
            File bookJson = new File(dir, "book.json");
            try (FileInputStream stream = new FileInputStream(bookJson);){
                BookRegistry.INSTANCE.loadBook(mod, Patchouli.class, res, stream, true);
            }
            catch (Exception e) {
                Patchouli.LOGGER.error("Failed to load external book json from {}, skipping", (Object)bookJson, (Object)e);
            }
        }
    }
}

