/*
 * Decompiled with CFR 0.152.
 */
package com.github.thegoldcrayon.tgcropesmod.block;

import com.github.thegoldcrayon.tgcropesmod.init.ModRegistry;
import com.github.thegoldcrayon.tgcropesmod.tileentity.DryingRackTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DryingRackBlock
extends HorizontalBlock {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final Logger LOGGER = LogManager.getLogger();
    private static final VoxelShape SHAPE_EAST_WEST = DryingRackBlock.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_NORTH_SOUTH = DryingRackBlock.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);

    public DryingRackBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200943_b(5.0f).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return state.func_196954_c(worldIn, pos);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_196954_c(worldIn, pos);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction facing = (Direction)state.func_177229_b((IProperty)FACING);
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            return SHAPE_NORTH_SOUTH;
        }
        return SHAPE_EAST_WEST;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)ModRegistry.DRYING_RACK_TILE_ENTITY_TYPE.get()).func_200968_a();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{FACING});
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileEntity;
        if (!worldIn.field_72995_K && (tileEntity = worldIn.func_175625_s(pos)) instanceof DryingRackTileEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((DryingRackTileEntity)tileEntity), (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }
}

