/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen.addon;

import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyBarScreenAddon
extends BasicScreenAddon {
    private final IEnergyStorage handler;
    private IAsset background;

    public EnergyBarScreenAddon(int posX, int posY, IEnergyStorage handler) {
        super(posX, posY);
        this.handler = handler;
    }

    public static IAsset drawBackground(Screen screen, IAssetProvider provider, int handlerPosX, int handlerPosY, int guiX, int guiY) {
        IAsset background = IAssetProvider.getAsset(provider, AssetTypes.ENERGY_BACKGROUND);
        Point offset = background.getOffset();
        Rectangle area = background.getArea();
        AssetUtil.drawAsset(screen, background, guiX + handlerPosX + offset.x, guiY + handlerPosY + offset.y);
        return background;
    }

    public static void drawForeground(Screen screen, IAssetProvider provider, int handlerPosX, int handlerPosY, int guiX, int guiY, int stored, int capacity) {
        IAsset asset = IAssetProvider.getAsset(provider, AssetTypes.ENERGY_BAR);
        Point offset = asset.getOffset();
        Rectangle area = asset.getArea();
        screen.getMinecraft().func_110434_K().func_110577_a(asset.getResourceLocation());
        int powerOffset = stored * area.height / capacity;
        screen.blit(handlerPosX + offset.x, handlerPosY + offset.y + area.height - powerOffset, area.x, area.y + (area.height - powerOffset), area.width, powerOffset);
    }

    public static List<String> getTooltip(int stored, int capacity) {
        return Arrays.asList(TextFormatting.GOLD + "Power:", new DecimalFormat().format(stored) + TextFormatting.GOLD + "/" + TextFormatting.WHITE + new DecimalFormat().format(capacity) + TextFormatting.DARK_AQUA + " FE");
    }

    @Override
    public int getXSize() {
        return this.background != null ? this.background.getArea().width : 0;
    }

    @Override
    public int getYSize() {
        return this.background != null ? this.background.getArea().height : 0;
    }

    @Override
    public void drawBackgroundLayer(Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        this.background = EnergyBarScreenAddon.drawBackground(screen, provider, this.getPosX(), this.getPosY(), guiX, guiY);
    }

    @Override
    public void drawForegroundLayer(Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY) {
        EnergyBarScreenAddon.drawForeground(screen, provider, this.getPosX(), this.getPosY(), guiX, guiY, this.handler.getEnergyStored(), this.handler.getMaxEnergyStored());
    }

    @Override
    public List<String> getTooltipLines() {
        return EnergyBarScreenAddon.getTooltip(this.handler.getEnergyStored(), this.handler.getMaxEnergyStored());
    }
}

