/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.crafting.StateIngredientBlock;
import vazkii.botania.common.crafting.StateIngredientBlockState;
import vazkii.botania.common.crafting.StateIngredientTag;

public class StateIngredientHelper {
    public static StateIngredient of(Block block) {
        return new StateIngredientBlock(block);
    }

    public static StateIngredient of(BlockState state) {
        return new StateIngredientBlockState(state);
    }

    public static StateIngredient of(Tag<Block> tag) {
        return new StateIngredientTag(tag);
    }

    public static StateIngredient of(ResourceLocation id) {
        return new StateIngredientTag(id);
    }

    public static StateIngredient deserialize(JsonObject object) {
        switch (JSONUtils.func_151200_h((JsonObject)object, (String)"type")) {
            case "tag": {
                return new StateIngredientTag((Tag<Block>)new BlockTags.Wrapper(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"tag"))));
            }
            case "block": {
                return new StateIngredientBlock((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"block"))));
            }
            case "state": {
                return new StateIngredientBlockState(StateIngredientHelper.readBlockState(object));
            }
        }
        throw new JsonParseException("Unknown type!");
    }

    public static StateIngredient read(PacketBuffer buffer) {
        switch (buffer.func_150792_a()) {
            case 0: {
                return new StateIngredientTag(buffer.func_192575_l());
            }
            case 1: {
                return new StateIngredientBlock((Block)buffer.readRegistryIdUnsafe(ForgeRegistries.BLOCKS));
            }
            case 2: {
                return new StateIngredientBlockState(Block.func_196257_b((int)buffer.func_150792_a()));
            }
        }
        throw new IllegalArgumentException("Unknown input discriminator!");
    }

    public static JsonObject serializeBlockState(BlockState state) {
        CompoundNBT nbt = NBTUtil.func_190009_a((BlockState)state);
        ItemNBTHelper.renameTag(nbt, "Name", "name");
        ItemNBTHelper.renameTag(nbt, "Properties", "properties");
        Dynamic dyn = new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)nbt);
        return ((JsonElement)dyn.convert((DynamicOps)JsonOps.INSTANCE).getValue()).getAsJsonObject();
    }

    public static BlockState readBlockState(JsonObject object) {
        CompoundNBT nbt = (CompoundNBT)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)object).convert((DynamicOps)NBTDynamicOps.field_210820_a).getValue();
        ItemNBTHelper.renameTag(nbt, "name", "Name");
        ItemNBTHelper.renameTag(nbt, "properties", "Properties");
        String name = nbt.func_74779_i("Name");
        ResourceLocation id = ResourceLocation.func_208304_a((String)name);
        if (id == null || !ForgeRegistries.BLOCKS.containsKey(id)) {
            throw new IllegalArgumentException("Invalid or unknown block ID: " + name);
        }
        return NBTUtil.func_190008_d((CompoundNBT)nbt);
    }
}

