/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.FloatBuffer;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.BipedRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.client.core.helper.ShaderCallback;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.client.core.helper.ShaderWrappedRenderLayer;
import vazkii.botania.common.entity.EntityDoppleganger;

public class RenderDoppleganger
extends BipedRenderer<EntityDoppleganger, BipedModel<EntityDoppleganger>> {
    private static final float DEFAULT_GRAIN_INTENSITY = 0.05f;
    private static final float DEFAULT_DISFIGURATION = 0.025f;
    private static float grainIntensity = 0.05f;
    private static float disfiguration = 0.025f;
    private static final ShaderCallback CALLBACK = shader -> {
        int disfigurationUniform = GlStateManager.func_227680_b_((int)shader, (CharSequence)"disfiguration");
        ShaderHelper.FLOAT_BUF.position(0);
        ShaderHelper.FLOAT_BUF.put(0, disfiguration);
        GlStateManager.func_227681_b_((int)disfigurationUniform, (FloatBuffer)ShaderHelper.FLOAT_BUF);
        int grainIntensityUniform = GlStateManager.func_227680_b_((int)shader, (CharSequence)"grainIntensity");
        ShaderHelper.FLOAT_BUF.position(0);
        ShaderHelper.FLOAT_BUF.put(0, grainIntensity);
        GlStateManager.func_227681_b_((int)grainIntensityUniform, (FloatBuffer)ShaderHelper.FLOAT_BUF);
    };
    public static final ShaderCallback defaultCallback = shader -> {
        int disfigurationUniform = GlStateManager.func_227680_b_((int)shader, (CharSequence)"disfiguration");
        ShaderHelper.FLOAT_BUF.position(0);
        ShaderHelper.FLOAT_BUF.put(0, 0.025f);
        GlStateManager.func_227681_b_((int)disfigurationUniform, (FloatBuffer)ShaderHelper.FLOAT_BUF);
        int grainIntensityUniform = GlStateManager.func_227680_b_((int)shader, (CharSequence)"grainIntensity");
        ShaderHelper.FLOAT_BUF.position(0);
        ShaderHelper.FLOAT_BUF.put(0, 0.05f);
        GlStateManager.func_227681_b_((int)grainIntensityUniform, (FloatBuffer)ShaderHelper.FLOAT_BUF);
    };

    public RenderDoppleganger(EntityRendererManager renderManager) {
        super(renderManager, (BipedModel)new Model(), 0.0f);
    }

    public void render(@Nonnull EntityDoppleganger dopple, float yaw, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffers, int light) {
        int invulTime = dopple.getInvulTime();
        if (invulTime > 0) {
            grainIntensity = invulTime > 20 ? 1.0f : (float)invulTime * 0.05f;
            disfiguration = grainIntensity * 0.3f;
        } else {
            disfiguration = (0.025f + (float)dopple.field_70737_aN * 0.0425f) / 2.0f;
            grainIntensity = 0.05f + (float)dopple.field_70737_aN * 0.085f;
        }
        super.func_225623_a_((MobEntity)dopple, yaw, partialTicks, ms, buffers, light);
    }

    @Nonnull
    public ResourceLocation getEntityTexture(@Nonnull EntityDoppleganger entity) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.func_175606_aa() instanceof AbstractClientPlayerEntity)) {
            return DefaultPlayerSkin.func_177334_a((UUID)entity.func_110124_au());
        }
        return ((AbstractClientPlayerEntity)mc.func_175606_aa()).func_110306_p();
    }

    protected boolean func_225622_a_(EntityDoppleganger dopple) {
        return true;
    }

    private static class Model
    extends BipedModel<EntityDoppleganger> {
        private static RenderType makeRenderType(ResourceLocation texture) {
            RenderType normal = RenderType.func_228644_e_((ResourceLocation)texture);
            return new ShaderWrappedRenderLayer(ShaderHelper.BotaniaShader.DOPPLEGANGER, CALLBACK, normal);
        }

        Model() {
            super(Model::makeRenderType, 0.0f, 0.0f, 64, 64);
        }
    }
}

