/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modules;

import java.util.ArrayList;
import java.util.List;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.WorldTools;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import mcjty.rftoolsutility.modules.screen.modules.ScreenModuleHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;

public class ElevatorButtonScreenModule
implements IScreenModule<ModuleElevatorInfo> {
    protected DimensionType dim = DimensionType.field_223227_a_;
    protected BlockPos coordinate = BlockPosTools.INVALID;
    protected ScreenModuleHelper helper = new ScreenModuleHelper();
    private boolean vertical = false;
    private boolean large = false;

    public ModuleElevatorInfo getData(IScreenDataHelper helper, World worldObj, long millis) {
        ServerWorld world = WorldTools.getWorld((World)worldObj, (DimensionType)this.dim);
        if (world == null) {
            return null;
        }
        if (!WorldTools.isLoaded((World)world, (BlockPos)this.coordinate)) {
            return null;
        }
        TileEntity te = world.func_175625_s(this.coordinate);
        return null;
    }

    public void setupFromNBT(CompoundNBT tagCompound, DimensionType dim, BlockPos pos) {
        if (tagCompound != null) {
            this.coordinate = BlockPosTools.INVALID;
            if (tagCompound.func_74764_b("elevatorx")) {
                this.dim = tagCompound.func_74764_b("elevatordim") ? DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(tagCompound.func_74779_i("elevatordim"))) : DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(tagCompound.func_74779_i("dim")));
                if (dim == this.dim) {
                    BlockPos c = new BlockPos(tagCompound.func_74762_e("elevatorx"), tagCompound.func_74762_e("elevatory"), tagCompound.func_74762_e("elevatorz"));
                    int dx = Math.abs(c.func_177958_n() - pos.func_177958_n());
                    int dz = Math.abs(c.func_177952_p() - pos.func_177952_p());
                    if (dx <= 64 && dz <= 64) {
                        this.coordinate = c;
                    }
                }
                this.vertical = tagCompound.func_74767_n("vertical");
                this.large = tagCompound.func_74767_n("large");
            }
        }
    }

    public void mouseClick(World world, int x, int y, boolean clicked, PlayerEntity player) {
        if (BlockPosTools.INVALID.equals((Object)this.coordinate)) {
            if (player != null) {
                player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Module is not linked to elevator!"), false);
            }
            return;
        }
        ServerWorld w = WorldTools.getWorld((World)world, (DimensionType)this.dim);
        if (w == null) {
            return;
        }
        if (!WorldTools.isLoaded((World)world, (BlockPos)this.coordinate)) {
            return;
        }
    }

    public static int getColumnWidth(int numcols) {
        int colw;
        switch (numcols) {
            case 1: {
                colw = 120;
                break;
            }
            case 2: {
                colw = 58;
                break;
            }
            case 3: {
                colw = 36;
                break;
            }
            case 4: {
                colw = 25;
                break;
            }
            case 5: {
                colw = 19;
                break;
            }
            default: {
                colw = 15;
            }
        }
        return colw;
    }

    public int getRfPerTick() {
        return (Integer)ScreenConfiguration.ELEVATOR_BUTTON_RFPERTICK.get();
    }

    public static class ModuleElevatorInfo
    implements IModuleData {
        public static final String ID = "rftoolsutility:elevator";
        private int level;
        private int maxLevel;
        private BlockPos pos;
        private List<Integer> heights;

        public String getId() {
            return ID;
        }

        public ModuleElevatorInfo(int level, int maxLevel, BlockPos pos, List<Integer> heights) {
            this.level = level;
            this.maxLevel = maxLevel;
            this.pos = pos;
            this.heights = heights;
        }

        public ModuleElevatorInfo(PacketBuffer buf) {
            this.level = buf.readInt();
            this.maxLevel = buf.readInt();
            this.pos = buf.func_179259_c();
            int s = buf.readByte();
            this.heights = new ArrayList<Integer>(s);
            for (int i = 0; i < s; ++i) {
                this.heights.add(Integer.valueOf(buf.readShort()));
            }
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public List<Integer> getHeights() {
            return this.heights;
        }

        public int getLevel() {
            return this.level;
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }

        public void writeToBuf(PacketBuffer buf) {
            buf.writeInt(this.level);
            buf.writeInt(this.maxLevel);
            buf.func_179255_a(this.pos);
            buf.writeByte(this.heights.size());
            for (Integer height : this.heights) {
                buf.writeShort(height.intValue());
            }
        }
    }
}

