/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modules;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;

public class ComputerScreenModule
implements IScreenModule<ModuleComputerInfo> {
    private String tag = "";
    private final ModuleComputerInfo textList = new ModuleComputerInfo();

    public ModuleComputerInfo getData(IScreenDataHelper helper, World worldObj, long millis) {
        return this.textList;
    }

    public void setupFromNBT(CompoundNBT tagCompound, DimensionType dim, BlockPos pos) {
        if (tagCompound != null) {
            this.tag = tagCompound.func_74779_i("moduleTag");
        }
    }

    public String getTag() {
        return this.tag;
    }

    public void addText(String text, int color) {
        this.textList.add(new ColoredText(text, color));
    }

    public void clearText() {
        this.textList.clear();
    }

    public int getRfPerTick() {
        return (Integer)ScreenConfiguration.COMPUTER_RFPERTICK.get();
    }

    public void mouseClick(World world, int x, int y, boolean clicked, PlayerEntity player) {
    }

    public boolean needsController() {
        return true;
    }

    public static class ColoredText {
        private final String text;
        private final int color;

        public ColoredText(String text, int color) {
            this.text = text;
            this.color = color;
        }

        public String getText() {
            return this.text;
        }

        public int getColor() {
            return this.color;
        }
    }

    public static class ModuleComputerInfo
    extends ArrayList<ColoredText>
    implements IModuleData {
        public static final String ID = "rftoolsutility:computer";

        public String getId() {
            return ID;
        }

        public ModuleComputerInfo() {
        }

        public ModuleComputerInfo(ByteBuf buf) {
            for (int i = buf.readInt(); i > 0; --i) {
                this.add(new ColoredText(((PacketBuffer)buf).func_150789_c(Short.MAX_VALUE), buf.readInt()));
            }
        }

        public void writeToBuf(PacketBuffer buf) {
            buf.writeInt(this.size());
            for (ColoredText i : this) {
                buf.func_180714_a(i.getText());
                buf.writeInt(i.getColor());
            }
        }
    }
}

