/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic_view.ViewDistHandler;

import com.dynamic_view.DynView;
import com.dynamic_view.ViewDistHandler.IDynamicViewDistanceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class ServerDynamicViewDistanceManager
implements IDynamicViewDistanceManager {
    private static final int UPDATE_LEEWAY = 3;
    private static ServerDynamicViewDistanceManager instance;
    public static int minChunkViewDist;
    public static int maxChunkViewDist;
    public static double meanTickToStayBelow;
    private int currentChunkViewDist = 0;

    private ServerDynamicViewDistanceManager() {
    }

    public static IDynamicViewDistanceManager getInstance() {
        if (instance == null) {
            instance = new ServerDynamicViewDistanceManager();
        }
        return instance;
    }

    @Override
    public void initViewDist() {
        this.currentChunkViewDist = minChunkViewDist;
        ServerLifecycleHooks.getCurrentServer().func_184103_al().func_217884_a(minChunkViewDist);
    }

    @Override
    public void updateViewDistForMeanTick(int meanTickTime) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server.func_184103_al().func_181057_v().isEmpty()) {
            return;
        }
        if ((double)(meanTickTime - 3) > meanTickToStayBelow && this.currentChunkViewDist > minChunkViewDist) {
            --this.currentChunkViewDist;
            if (((Boolean)DynView.getConfig().getCommonConfig().logMessages.get()).booleanValue()) {
                DynView.LOGGER.info("Mean tick: " + meanTickTime + "ms decreasing chunk view distance to: " + this.currentChunkViewDist);
            }
            server.func_184103_al().func_217884_a(this.currentChunkViewDist);
        }
        if ((double)(meanTickTime + 3) < meanTickToStayBelow && this.currentChunkViewDist < maxChunkViewDist) {
            ++this.currentChunkViewDist;
            if (((Boolean)DynView.getConfig().getCommonConfig().logMessages.get()).booleanValue()) {
                DynView.LOGGER.info("Mean tick: " + meanTickTime + "ms increasing chunk view distance to: " + this.currentChunkViewDist);
            }
            server.func_184103_al().func_217884_a(this.currentChunkViewDist);
        }
    }
}

