/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element;

import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementResourceStorage;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.RenderHelper;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.text.ITextComponent;

public class ElementFluidStorage
extends ElementResourceStorage {
    protected FluidStorageCoFH tank;
    protected TextureAtlasSprite fluidTexture;

    public ElementFluidStorage(IGuiAccess gui, int posX, int posY, FluidStorageCoFH storage) {
        super(gui, posX, posY, storage);
        this.tank = storage;
    }

    public ElementFluidStorage setFluidTexture(TextureAtlasSprite fluidTexture) {
        this.fluidTexture = fluidTexture;
        return this;
    }

    @Override
    protected void drawResource() {
        boolean invert;
        int resourceHeight = this.height - 2;
        int resourceWidth = this.width - 2;
        int amount = this.getScaled(resourceHeight);
        boolean bl = invert = FluidHelper.density(this.tank.getFluidStack()) < 0;
        if (this.fluidTexture != null) {
            RenderHelper.setBlockTextureSheet();
            RenderHelper.drawTiledTexture(this.posX + 1, this.posY + 1 + (invert ? 0 : resourceHeight - amount), this.fluidTexture, resourceWidth, amount);
        } else {
            RenderHelper.drawFluid(this.posX + 1, this.posY + 1 + (invert ? 0 : resourceHeight - amount), this.tank.getFluidStack(), resourceWidth, amount);
        }
    }

    @Override
    public void addTooltip(List<ITextComponent> tooltipList, int mouseX, int mouseY) {
        if (this.tank.getAmount() > 0) {
            tooltipList.add(StringHelper.getFluidName(this.tank.getFluidStack()));
            if (FluidHelper.hasPotionTag(this.tank.getFluidStack())) {
                FluidHelper.addPotionTooltip(this.tank.getFluidStack(), tooltipList);
            }
        }
        super.addTooltip(tooltipList, mouseX, mouseY);
    }
}

