/*
 * Decompiled with CFR 0.152.
 */
package cofh.core;

import cofh.core.client.gui.CoreTextures;
import cofh.core.command.CoFHCommand;
import cofh.core.data.CoreBlockStateProvider;
import cofh.core.data.CoreItemModelProvider;
import cofh.core.data.CoreLootTableProvider;
import cofh.core.data.CoreRecipeProvider;
import cofh.core.event.CoreClientEvents;
import cofh.core.event.CoreCommonEvents;
import cofh.core.init.CoreBlocks;
import cofh.core.init.CoreConfig;
import cofh.core.init.CoreEffects;
import cofh.core.init.CoreItems;
import cofh.core.network.packet.client.IndexedChatPacket;
import cofh.core.network.packet.client.TileControlPacket;
import cofh.core.network.packet.client.TileGuiPacket;
import cofh.core.network.packet.client.TileStatePacket;
import cofh.core.network.packet.server.MultiModeItemPacket;
import cofh.core.network.packet.server.RedstoneControlPacket;
import cofh.core.network.packet.server.SecurityControlPacket;
import cofh.core.network.packet.server.SecurityPacket;
import cofh.core.network.packet.server.SideConfigPacket;
import cofh.core.network.packet.server.TransferControlPacket;
import cofh.core.util.Proxy;
import cofh.core.util.ProxyClient;
import cofh.lib.capability.CapabilityAOE;
import cofh.lib.capability.CapabilityArchery;
import cofh.lib.capability.CapabilityEnchantable;
import cofh.lib.capability.CapabilityShield;
import cofh.lib.event.AOEClientEvents;
import cofh.lib.event.AOEEvents;
import cofh.lib.event.ArcheryEvents;
import cofh.lib.event.EffectEvents;
import cofh.lib.event.ShieldEvents;
import cofh.lib.network.PacketHandler;
import cofh.lib.registries.DeferredRegisterCoFH;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.block.Block;
import net.minecraft.command.CommandSource;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cofh_core")
public class CoFHCore {
    public static final Logger LOG = LogManager.getLogger((String)"cofh_core");
    public static final PacketHandler PACKET_HANDLER = new PacketHandler(new ResourceLocation("cofh_core", "general"));
    public static Proxy proxy = (Proxy)DistExecutor.runForDist(() -> ProxyClient::new, () -> Proxy::new);
    public static final DeferredRegisterCoFH<Block> BLOCKS = new DeferredRegisterCoFH(ForgeRegistries.BLOCKS, "cofh_core");
    public static final DeferredRegisterCoFH<Fluid> FLUIDS = new DeferredRegisterCoFH(ForgeRegistries.FLUIDS, "cofh_core");
    public static final DeferredRegisterCoFH<Effect> EFFECTS = new DeferredRegisterCoFH(ForgeRegistries.POTIONS, "cofh_core");
    public static final DeferredRegisterCoFH<Item> ITEMS = new DeferredRegisterCoFH(ForgeRegistries.ITEMS, "cofh_core");
    public static final DeferredRegisterCoFH<ParticleType<?>> PARTICLES = new DeferredRegisterCoFH(ForgeRegistries.PARTICLE_TYPES, "cofh_core");
    public static final DeferredRegisterCoFH<TileEntityType<?>> TILE_ENTITIES = new DeferredRegisterCoFH(ForgeRegistries.TILE_ENTITIES, "cofh_core");

    public CoFHCore() {
        this.registerPackets();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::gatherData);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        BLOCKS.register(modEventBus);
        FLUIDS.register(modEventBus);
        EFFECTS.register(modEventBus);
        ITEMS.register(modEventBus);
        TILE_ENTITIES.register(modEventBus);
        CoreConfig.register();
        CoreBlocks.register();
        CoreEffects.register();
        CoreItems.register();
    }

    private void registerPackets() {
        PACKET_HANDLER.registerPacket(1, TileControlPacket::new);
        PACKET_HANDLER.registerPacket(2, TileGuiPacket::new);
        PACKET_HANDLER.registerPacket(3, TileStatePacket::new);
        PACKET_HANDLER.registerPacket(12, IndexedChatPacket::new);
        PACKET_HANDLER.registerPacket(16, SecurityPacket::new);
        PACKET_HANDLER.registerPacket(24, SecurityControlPacket::new);
        PACKET_HANDLER.registerPacket(25, RedstoneControlPacket::new);
        PACKET_HANDLER.registerPacket(26, TransferControlPacket::new);
        PACKET_HANDLER.registerPacket(27, SideConfigPacket::new);
        PACKET_HANDLER.registerPacket(32, MultiModeItemPacket::new);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        CapabilityAOE.register();
        CapabilityArchery.register();
        CapabilityEnchantable.register();
        CapabilityShield.register();
        CoreCommonEvents.register();
        ArcheryEvents.register();
        AOEEvents.register();
        EffectEvents.register();
        ShieldEvents.register();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(CoreTextures::preStitch);
        modEventBus.addListener(CoreTextures::postStitch);
        CoreClientEvents.register();
        AOEClientEvents.register();
    }

    private void serverStarting(FMLServerStartingEvent event) {
        CoFHCommand.initialize((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    private void gatherData(GatherDataEvent event) {
        if (event.includeServer()) {
            this.registerServerProviders(event.getGenerator());
        }
        if (event.includeClient()) {
            this.registerClientProviders(event.getGenerator(), event);
        }
    }

    private void registerServerProviders(DataGenerator generator) {
        generator.func_200390_a((IDataProvider)new CoreLootTableProvider(generator));
        generator.func_200390_a((IDataProvider)new CoreRecipeProvider(generator));
    }

    private void registerClientProviders(DataGenerator generator, GatherDataEvent event) {
        generator.func_200390_a((IDataProvider)new CoreBlockStateProvider(generator, event.getExistingFileHelper()));
        generator.func_200390_a((IDataProvider)new CoreItemModelProvider(generator, event.getExistingFileHelper()));
    }
}

