/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.utils;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Predicate;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;

public final class Utils {
    public static final ImmutableList<Direction> DIRECTIONS = ImmutableList.copyOf((Object[])Direction.values());

    private Utils() {
    }

    public static boolean hasCapabilityAtAll(ICapabilityProvider provider, Capability<?> cap) {
        for (Direction direction : DIRECTIONS) {
            if (!provider.getCapability(cap, direction).isPresent()) continue;
            return true;
        }
        return provider.getCapability(cap).isPresent();
    }

    public static int lowerBound(int n, int lowerBound) {
        return Math.max(n, lowerBound);
    }

    public static int upperBound(int n, int upperBound) {
        return Math.min(n, upperBound);
    }

    public static int[] rangedIntArray(int start, int end) {
        int[] result = new int[end - start];
        Arrays.setAll(result, i -> i + start);
        return result;
    }

    public static boolean invertIf(boolean bool, boolean predicate) {
        return bool ^ predicate;
    }

    public static <T> Predicate<T> not(Predicate<T> original) {
        return original.negate();
    }

    public static Iterable<BlockPos> neighbors(BlockPos center) {
        return () -> Utils.neighborsIterator(center);
    }

    public static Iterator<BlockPos> neighborsIterator(final BlockPos center) {
        return new AbstractIterator<BlockPos>(){
            private int index = 0;

            protected BlockPos computeNext() {
                if (this.index >= DIRECTIONS.size()) {
                    return (BlockPos)this.endOfData();
                }
                return center.func_177972_a((Direction)DIRECTIONS.get(this.index++));
            }
        };
    }

    public static boolean isInside(int x, int y, int mx, int my) {
        return Utils.isInside(x, y, 0, 0, mx, my);
    }

    public static boolean isInside(int x, int y, int bx1, int by1, int bx2, int by2) {
        return x >= bx1 && x < bx2 && y >= by1 && y < by2;
    }

    public static void dropInventoryItems(World world, BlockPos pos, IItemHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
        }
    }
}

