/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.logic.procedure;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import vswe.stevesfactory.api.logic.IExecutionContext;
import vswe.stevesfactory.logic.AbstractProcedure;
import vswe.stevesfactory.logic.ModProcedures;
import vswe.stevesfactory.logic.item.DirectBufferElement;
import vswe.stevesfactory.logic.item.IItemFilter;
import vswe.stevesfactory.logic.item.ItemTraitsFilter;
import vswe.stevesfactory.logic.procedure.IDirectionTarget;
import vswe.stevesfactory.logic.procedure.IInventoryTarget;
import vswe.stevesfactory.logic.procedure.IItemFilterTarget;
import vswe.stevesfactory.ui.manager.editor.FlowComponent;
import vswe.stevesfactory.ui.manager.editor.PropertyManager;
import vswe.stevesfactory.ui.manager.menu.DirectionSelectionMenu;
import vswe.stevesfactory.ui.manager.menu.InventorySelectionMenu;
import vswe.stevesfactory.utils.IOHelper;
import vswe.stevesfactory.utils.NetworkHelper;

public class ItemImportProcedure
extends AbstractProcedure
implements IInventoryTarget,
IDirectionTarget,
IItemFilterTarget {
    public static final int INVENTORIES = 0;
    public static final int FILTER = 0;
    private List<BlockPos> inventories = new ArrayList<BlockPos>();
    private Set<Direction> directions = EnumSet.noneOf(Direction.class);
    private IItemFilter filter = new ItemTraitsFilter();
    private transient List<LazyOptional<IItemHandler>> cachedCaps = new ArrayList<LazyOptional<IItemHandler>>();
    private transient boolean dirty = false;

    public ItemImportProcedure() {
        super(ModProcedures.itemImport);
    }

    @Override
    public void execute(IExecutionContext context) {
        this.pushFrame(context, 0);
        if (this.hasError()) {
            return;
        }
        this.updateCaches(context);
        Map<Item, DirectBufferElement> buffers = context.getItemBuffers(DirectBufferElement.class);
        VisitedInventories visited = NetworkHelper.obtainCustomData(context, VisitedInventories.class, () -> new VisitedInventories());
        for (LazyOptional<IItemHandler> cap : this.cachedCaps) {
            cap.ifPresent(handler -> {
                if (!visited.add(handler)) {
                    return;
                }
                this.filter.extractFromInventory((IItemHandler)handler, (stack, slot) -> {
                    int count = stack.func_190916_E();
                    DirectBufferElement element = buffers.computeIfAbsent(stack.func_77973_b(), key -> {
                        stack.func_190920_e(0);
                        return new DirectBufferElement((ItemStack)stack);
                    });
                    element.stack.func_190917_f(count);
                    element.addInventory((IItemHandler)handler, (int)slot);
                });
            });
        }
    }

    public boolean hasError() {
        return this.inventories.isEmpty() || this.directions.isEmpty();
    }

    private void updateCaches(IExecutionContext context) {
        if (!this.dirty) {
            return;
        }
        this.cachedCaps.clear();
        NetworkHelper.cacheDirectionalCaps(context, this.cachedCaps, this.inventories, this.directions, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, __ -> this.markDirty());
        this.dirty = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public FlowComponent<ItemImportProcedure> createFlowComponent() {
        FlowComponent<ItemImportProcedure> f = FlowComponent.of(this);
        f.addMenu(new InventorySelectionMenu(0, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY));
        f.addMenu(new DirectionSelectionMenu(0));
        PropertyManager.createFilterMenu(this, f, 0);
        return f;
    }

    @Override
    public CompoundNBT serialize() {
        CompoundNBT tag = super.serialize();
        tag.func_218657_a("Inventories", (INBT)IOHelper.writeBlockPoses(this.inventories));
        tag.func_74783_a("Directions", IOHelper.direction2Index(this.directions));
        tag.func_218657_a("Filter", (INBT)IOHelper.writeItemFilter(this.filter));
        return tag;
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        super.deserialize(tag);
        this.inventories = IOHelper.readBlockPoses(tag.func_150295_c("Inventories", 10), new ArrayList());
        this.directions = IOHelper.index2DirectionFill(tag.func_74759_k("Directions"), EnumSet.noneOf(Direction.class));
        this.filter = IOHelper.readItemFilter(tag.func_74775_l("Filter"));
        this.markDirty();
    }

    @Override
    public Set<Direction> getDirections(int id) {
        return this.directions;
    }

    @Override
    public List<BlockPos> getInventories(int id) {
        return this.inventories;
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }

    @Override
    public IItemFilter getFilter(int id) {
        return this.filter;
    }

    @Override
    public void setFilter(int id, IItemFilter filter) {
        if (id == 0) {
            this.filter = filter;
        }
    }

    private static final class VisitedInventories
    extends HashSet<IItemHandler> {
        private VisitedInventories() {
        }
    }
}

