/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.logic.item;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.items.IItemHandler;
import vswe.stevesfactory.logic.FilterType;
import vswe.stevesfactory.logic.item.IItemFilter;
import vswe.stevesfactory.utils.IOHelper;
import vswe.stevesfactory.utils.Utils;

public class ItemTraitsFilter
implements IItemFilter {
    private static int TYPE_ID = IItemFilter.ItemFilters.allocateID(ItemTraitsFilter::recover);
    private List<ItemStack> items = new ArrayList<ItemStack>();
    public FilterType type = FilterType.WHITELIST;
    private boolean matchingDamage;
    private boolean matchingTag;
    private boolean matchingAmount;

    @Override
    public FilterType getType() {
        return this.type;
    }

    @Override
    public void setType(FilterType type) {
        this.type = type;
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public boolean isMatchingDamage() {
        return this.matchingDamage;
    }

    public void setMatchingDamage(boolean matchingDamage) {
        this.matchingDamage = matchingDamage;
    }

    public boolean isMatchingTag() {
        return this.matchingTag;
    }

    public void setMatchingTag(boolean matchingTag) {
        this.matchingTag = matchingTag;
    }

    @Override
    public boolean isMatchingAmount() {
        return this.matchingAmount;
    }

    @Override
    public void setMatchingAmount(boolean matchingAmount) {
        this.matchingAmount = matchingAmount;
    }

    @Override
    public boolean test(ItemStack stack) {
        boolean trueOnMatched = this.type == FilterType.WHITELIST;
        boolean trueOnUnmatched = this.type == FilterType.BLACKLIST;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.isEqual(i, stack)) continue;
            return trueOnMatched;
        }
        return trueOnUnmatched;
    }

    @Override
    public void extractFromInventory(IItemHandler handler, List<ItemStack> target, boolean merge) {
        Object2LongMap<Item> counts = this.constructResultMap();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.extractItem(i, Integer.MAX_VALUE, true);
            if (stack.func_190926_b() || !this.test(stack) || this.processExtractableStack(counts, stack) || merge) continue;
            target.add(stack);
        }
        if (merge) {
            for (Object2LongMap.Entry entry : counts.object2LongEntrySet()) {
                long data = entry.getLongValue();
                ItemStack stack = new ItemStack((IItemProvider)entry.getKey(), this.getExtractedCount(data));
                target.add(stack);
            }
        }
    }

    @Override
    public void extractFromInventory(IItemHandler handler, BiConsumer<ItemStack, Integer> receiver) {
        Object2LongMap<Item> counts = this.constructResultMap();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.extractItem(i, Integer.MAX_VALUE, true);
            if (stack.func_190926_b() || !this.test(stack) || this.processExtractableStack(counts, stack)) continue;
            receiver.accept(stack, i);
        }
    }

    private boolean processExtractableStack(Object2LongMap<Item> counts, ItemStack stack) {
        Item item = stack.func_77973_b();
        long data = counts.getOrDefault((Object)item, Integer.MAX_VALUE);
        int desired = this.getDesiredCount(data);
        if (desired <= 0) {
            return true;
        }
        int extracted = this.getExtractedCount(data);
        int used = Utils.upperBound(stack.func_190916_E(), desired);
        stack.func_190920_e(used);
        counts.put((Object)item, this.getData(extracted + used, desired - used));
        return false;
    }

    private Object2LongMap<Item> constructResultMap() {
        Object2LongOpenHashMap counts = new Object2LongOpenHashMap();
        if (this.type == FilterType.WHITELIST) {
            for (ItemStack item : this.items) {
                if (item.func_190926_b()) continue;
                counts.put((Object)item.func_77973_b(), this.getData(0, this.matchingAmount ? item.func_190916_E() : Integer.MAX_VALUE));
            }
        }
        return counts;
    }

    private int getDesiredCount(long data) {
        return (int)data;
    }

    private int getExtractedCount(long data) {
        return (int)(data >>> 32);
    }

    private long getData(int extracted, int desired) {
        return (long)extracted << 32 | (long)desired;
    }

    public boolean isEqual(int filterIndex, ItemStack stack) {
        ItemStack item = this.items.get(filterIndex);
        return !(!item.func_77969_a(stack) || this.matchingDamage && item.func_77952_i() != stack.func_77952_i() || this.matchingTag && !item.areShareTagsEqual(stack));
    }

    public boolean doesItemMatch(int filterIndex, ItemStack stack) {
        return this.isEqual(filterIndex, stack) ^ this.getTypeFlag();
    }

    @Override
    public int limitFlowRate(ItemStack buffered, int existingCount) {
        int stackLimit = Integer.MAX_VALUE;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.isEqual(i, buffered)) continue;
            stackLimit = this.items.get(i).func_190916_E();
            break;
        }
        return Utils.lowerBound(stackLimit - existingCount, 0);
    }

    private boolean getTypeFlag() {
        switch (this.type) {
            case WHITELIST: {
                return false;
            }
            case BLACKLIST: {
                return true;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public int getTypeID() {
        return TYPE_ID;
    }

    @Override
    public void read(CompoundNBT tag) {
        this.type = tag.func_74767_n("Blacklist") ? FilterType.BLACKLIST : FilterType.WHITELIST;
        this.items = IOHelper.readItemStacks(tag.func_150295_c("Items", 10), new ArrayList());
        this.matchingDamage = tag.func_74767_n("MatchDamage");
        this.matchingTag = tag.func_74767_n("MatchTag");
        this.matchingAmount = tag.func_74767_n("MatchAmount");
    }

    @Override
    public void write(CompoundNBT tag) {
        tag.func_74757_a("Blacklist", this.type == FilterType.BLACKLIST);
        tag.func_218657_a("Items", (INBT)IOHelper.writeItemStacks(this.items));
        tag.func_74757_a("MatchDamage", this.matchingDamage);
        tag.func_74757_a("MatchTag", this.matchingTag);
        tag.func_74757_a("MatchAmount", this.matchingAmount);
    }

    public static ItemTraitsFilter recover(CompoundNBT tag) {
        ItemTraitsFilter filter = new ItemTraitsFilter();
        filter.read(tag);
        return filter;
    }
}

