/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui.widget.mixin;

import vswe.stevesfactory.library.gui.widget.IContainer;
import vswe.stevesfactory.library.gui.widget.IWidget;

public interface ContainerWidgetMixin<T extends IWidget>
extends IContainer<T> {
    @Override
    default public void render(int mouseX, int mouseY, float particleTicks) {
        for (IWidget child : this.getChildren()) {
            child.render(mouseX, mouseY, particleTicks);
        }
    }

    @Override
    default public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (IWidget child : this.getChildren()) {
            if (!(child instanceof IContainer) && !child.isInside(mouseX, mouseY) || !child.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    @Override
    default public boolean mouseReleased(double mouseX, double mouseY, int button) {
        for (IWidget child : this.getChildren()) {
            if (!(child instanceof IContainer) && !child.isInside(mouseX, mouseY) || !child.mouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    @Override
    default public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        for (IWidget child : this.getChildren()) {
            if (!(child instanceof IContainer) && !child.isFocused() || !child.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) continue;
            return true;
        }
        return false;
    }

    @Override
    default public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        for (IWidget child : this.getChildren()) {
            if (!(child instanceof IContainer) && !child.isInside(mouseX, mouseY) || !child.mouseScrolled(mouseX, mouseY, scroll)) continue;
            return true;
        }
        return false;
    }

    @Override
    default public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (IWidget child : this.getChildren()) {
            if (!(child instanceof IContainer) && !child.isFocused() || !child.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    default public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        for (IWidget child : this.getChildren()) {
            if (!(child instanceof IContainer) && !child.isFocused() || !child.keyReleased(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    default public boolean charTyped(char charTyped, int keyCode) {
        for (IWidget child : this.getChildren()) {
            if (!(child instanceof IContainer) && !child.isFocused() || !child.charTyped(charTyped, keyCode)) continue;
            return true;
        }
        return false;
    }

    @Override
    default public void mouseMoved(double mouseX, double mouseY) {
        for (IWidget child : this.getChildren()) {
            child.mouseMoved(mouseX, mouseY);
        }
    }

    @Override
    default public void update(float particleTicks) {
        for (IWidget child : this.getChildren()) {
            child.update(particleTicks);
        }
    }

    @Override
    default public void setParentWidget(IWidget newParent) {
        if (this.getChildren() != null) {
            for (IWidget child : this.getChildren()) {
                child.setParentWidget(this);
            }
        }
    }

    @Override
    default public void onRemoved() {
        for (IWidget child : this.getChildren()) {
            child.onRemoved();
        }
    }
}

