/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;
import vswe.stevesfactory.StevesFactoryManager;
import vswe.stevesfactory.library.collections.CompositeUnmodifiableList;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.TextureWrapper;
import vswe.stevesfactory.library.gui.debug.Inspections;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.screen.WidgetContainer;
import vswe.stevesfactory.library.gui.screen.WidgetTreeInspections;
import vswe.stevesfactory.library.gui.window.IPopupWindow;
import vswe.stevesfactory.library.gui.window.IWindow;

public abstract class WidgetScreen<C extends WidgetContainer>
extends ContainerScreen<C>
implements IGuiEventListener {
    public static final TextureWrapper ITEM_SLOT = TextureWrapper.ofFlowComponent(0, 106, 18, 18);
    private IWindow primaryWindow;
    private List<IWindow> regularWindows = new ArrayList<IWindow>();
    private List<IPopupWindow> popupWindows = new ArrayList<IPopupWindow>();
    private Collection<IWindow> windows;
    private final Queue<Consumer<WidgetScreen>> tasks = new ArrayDeque<Consumer<WidgetScreen>>();
    private final WidgetTreeInspections inspectionHandler = new WidgetTreeInspections();
    private final ArrayList<String> cachedHoveringTextList = new ArrayList();
    private List<String> hoveringText;
    private int hoveringTextX;
    private int hoveringTextY;

    public static WidgetScreen getCurrent() {
        return (WidgetScreen)Minecraft.func_71410_x().field_71462_r;
    }

    public static int screenWidth() {
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen != null) {
            return screen.width;
        }
        return 0;
    }

    public static int screenHeight() {
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen != null) {
            return screen.height;
        }
        return 0;
    }

    protected WidgetScreen(C container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        List<IPopupWindow> popupWindows = this.popupWindows;
        this.windows = CompositeUnmodifiableList.of(this.regularWindows, popupWindows);
    }

    protected void init() {
        StevesFactoryManager.logger.trace("(Re)initialized widget-based GUI {}", (Object)this);
        this.primaryWindow = null;
        this.regularWindows.clear();
        this.popupWindows.clear();
        RenderEventDispatcher.listeners.put(Inspections.class, this.inspectionHandler);
    }

    public void tick() {
        while (!this.tasks.isEmpty()) {
            this.tasks.remove().accept(this);
        }
        this.popupWindows.removeIf(popup -> {
            if (popup.shouldDiscard()) {
                popup.onRemoved();
                return true;
            }
            return false;
        });
        float particleTicks = Minecraft.func_71410_x().func_184121_ak();
        for (IWindow window : this.windows) {
            window.update(particleTicks);
        }
        this.primaryWindow.update(particleTicks);
    }

    protected void initializePrimaryWindow(IWindow primaryWindow) {
        if (this.primaryWindow != null) {
            throw new IllegalStateException("Already initialized the primary window " + this.primaryWindow);
        }
        this.primaryWindow = primaryWindow;
        this.field_146999_f = primaryWindow.getWidth();
        this.field_147000_g = primaryWindow.getHeight();
    }

    public IWindow getPrimaryWindow() {
        return this.primaryWindow;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderBackground();
        RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
        RenderSystem.enableAlphaTest();
        this.inspectionHandler.startCycle();
        this.primaryWindow.render(mouseX, mouseY, partialTicks);
        for (IWindow window : this.windows) {
            window.render(mouseX, mouseY, partialTicks);
        }
        this.inspectionHandler.endCycle();
        if (this.hoveringText != null) {
            GuiUtils.drawHoveringText(this.hoveringText, (int)this.hoveringTextX, (int)this.hoveringTextY, (int)WidgetScreen.screenWidth(), (int)WidgetScreen.screenHeight(), (int)Integer.MAX_VALUE, (FontRenderer)this.font);
            this.hoveringText = null;
        }
    }

    public void addWindow(IWindow window) {
        this.regularWindows.add(window);
    }

    public void clearWindows() {
        this.regularWindows.forEach(IWindow::onRemoved);
        this.regularWindows.clear();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.windows.stream().anyMatch(window -> window.mouseClicked(mouseX, mouseY, button))) {
            return true;
        }
        return this.primaryWindow.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.windows.stream().anyMatch(window -> window.mouseReleased(mouseX, mouseY, button))) {
            return true;
        }
        return this.primaryWindow.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragAmountX, double dragAmountY) {
        if (this.windows.stream().anyMatch(window -> window.mouseDragged(mouseX, mouseY, button, dragAmountX, dragAmountY))) {
            return true;
        }
        return this.primaryWindow.mouseDragged(mouseX, mouseY, button, dragAmountX, dragAmountY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountScrolled) {
        if (this.windows.stream().anyMatch(window -> window.mouseScrolled(mouseX, mouseY, amountScrolled))) {
            return true;
        }
        return this.primaryWindow.mouseScrolled(mouseX, mouseY, amountScrolled);
    }

    public void func_212927_b(double mouseX, double mouseY) {
        for (IWindow window : this.windows) {
            window.mouseMoved(mouseX, mouseY);
        }
        this.primaryWindow.mouseMoved(mouseX, mouseY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.windows.stream().anyMatch(window -> window.keyPressed(keyCode, scanCode, modifiers))) {
            return true;
        }
        if (this.primaryWindow.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 69) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
            return true;
        }
        return false;
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        if (this.windows.stream().anyMatch(window -> window.keyReleased(keyCode, scanCode, modifiers))) {
            return true;
        }
        return this.primaryWindow.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char charTyped, int keyCode) {
        if (this.windows.stream().anyMatch(window -> window.charTyped(charTyped, keyCode))) {
            return true;
        }
        return this.primaryWindow.charTyped(charTyped, keyCode);
    }

    public void removed() {
        for (IWindow window : this.windows) {
            window.onRemoved();
        }
        this.primaryWindow.onRemoved();
        super.removed();
    }

    public void scheduleTask(Consumer<WidgetScreen> task) {
        this.tasks.add(task);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void setHoveringText(List<String> hoveringText, int x, int y) {
        this.hoveringText = hoveringText;
        this.hoveringTextX = x + RenderingHelper.getTranslationX();
        this.hoveringTextY = y + RenderingHelper.getTranslationY();
    }

    public void setHoveringText(ItemStack stack, int x, int y) {
        this.setHoveringText(this.getTooltipFromItem(stack), x, y);
    }

    public void setHoveringText(String hoveringText, int x, int y) {
        this.cachedHoveringTextList.clear();
        this.cachedHoveringTextList.add(hoveringText);
        this.setHoveringText(this.cachedHoveringTextList, x, y);
    }

    public void addPopupWindow(IPopupWindow popup) {
        this.popupWindows.add(popup);
    }

    public void removePopupWindow(IPopupWindow popup) {
        this.popupWindows.remove(popup);
        popup.onRemoved();
    }
}

