/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui.screen;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.awt.Rectangle;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;
import vswe.stevesfactory.StevesFactoryManager;
import vswe.stevesfactory.library.gui.screen.BackgroundRenderers;

@OnlyIn(value=Dist.CLIENT)
public final class DisplayListCaches {
    private static final Cache<Rectangle, Integer> VANILLA_BACKGROUND_CACHE = CacheBuilder.newBuilder().expireAfterAccess(120L, TimeUnit.SECONDS).removalListener(removal -> {
        StevesFactoryManager.logger.info("Removed background display list with size {}", removal.getKey());
        GL11.glDeleteLists((int)((Integer)removal.getValue()), (int)1);
    }).build();

    private DisplayListCaches() {
    }

    public static int createVanillaStyleBackground(Rectangle rectangle) {
        return DisplayListCaches.createVanillaStyleBackground(rectangle, 0.0f);
    }

    public static int createVanillaStyleBackground(Rectangle rectangle, float z) {
        try {
            return (Integer)VANILLA_BACKGROUND_CACHE.get((Object)rectangle, () -> {
                StevesFactoryManager.logger.info("Created background display list with size {}", (Object)rectangle);
                int id = GL11.glGenLists((int)1);
                GL11.glNewList((int)id, (int)4864);
                BackgroundRenderers.drawVanillaStyle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, z);
                GL11.glEndList();
                return id;
            });
        }
        catch (ExecutionException e) {
            StevesFactoryManager.logger.error("Exception when creating OpenGL display list for {} for vanilla-style background", (Object)rectangle, (Object)e);
            return -1;
        }
    }

    public static int createVanillaStyleBackground(int x, int y, int width, int height) {
        return DisplayListCaches.createVanillaStyleBackground(new Rectangle(x, y, width, height));
    }
}

